/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection;

import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.quorum.pool.connection.ConnectionPin;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.DeconstructionFuse;
import org.smallmind.quorum.pool.connection.DeconstructionQueue;
import org.smallmind.quorum.pool.connection.MaxIdleTimeDeconstructionFuse;
import org.smallmind.quorum.pool.connection.MaxLeaseTimeDeconstructionFuse;
import org.smallmind.quorum.pool.connection.UnreturnedConnectionTimeoutDeconstructionFuse;

public class DeconstructionCoordinator {
    private final ConnectionPin<?> connectionPin;
    private final List<DeconstructionFuse> fuseList;
    private final AtomicBoolean terminated = new AtomicBoolean(false);

    public DeconstructionCoordinator(ConnectionPool<?> connectionPool, DeconstructionQueue deconstructionQueue, ConnectionPin<?> connectionPin) {
        this.connectionPin = connectionPin;
        this.fuseList = new LinkedList<DeconstructionFuse>();
        if (connectionPool.getConnectionPoolConfig().getMaxLeaseTimeSeconds() > 0) {
            this.fuseList.add(new MaxLeaseTimeDeconstructionFuse(connectionPool, deconstructionQueue, this));
        }
        if (connectionPool.getConnectionPoolConfig().getMaxIdleTimeSeconds() > 0) {
            this.fuseList.add(new MaxIdleTimeDeconstructionFuse(connectionPool, deconstructionQueue, this));
        }
        if (connectionPool.getConnectionPoolConfig().getUnReturnedElementTimeoutSeconds() > 0) {
            this.fuseList.add(new UnreturnedConnectionTimeoutDeconstructionFuse(connectionPool, deconstructionQueue, this));
        }
    }

    public void free() {
        for (DeconstructionFuse fuse : this.fuseList) {
            fuse.free();
        }
    }

    public void serve() {
        for (DeconstructionFuse fuse : this.fuseList) {
            fuse.serve();
        }
    }

    public void abort() {
        if (this.terminated.compareAndSet(false, true)) {
            this.shutdown(null);
        }
    }

    public void ignite(DeconstructionFuse ignitionFuse, boolean withPrejudice) {
        if (this.terminated.compareAndSet(false, true)) {
            this.shutdown(ignitionFuse);
            this.connectionPin.kaboom(withPrejudice);
        }
    }

    private void shutdown(DeconstructionFuse ignitionFuse) {
        for (DeconstructionFuse fuse : this.fuseList) {
            if (fuse.equals(ignitionFuse)) continue;
            fuse.abort();
        }
    }
}

