/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.connection.jmx;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.UnknownHostException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import javax.naming.NamingException;
import org.smallmind.quorum.pool.connection.ConnectionPool;
import org.smallmind.quorum.pool.connection.ConnectionPoolException;
import org.smallmind.quorum.pool.connection.event.ConnectionPoolEventListener;
import org.smallmind.quorum.pool.connection.event.ErrorReportingConnectionPoolEvent;
import org.smallmind.quorum.pool.connection.event.LeaseTimeReportingConnectionPoolEvent;
import org.smallmind.quorum.pool.connection.jmx.ConnectionErrorOccurredNotification;
import org.smallmind.quorum.pool.connection.jmx.ConnectionLeaseTimeNotification;
import org.smallmind.quorum.pool.connection.jmx.ConnectionPoolMonitorMXBean;
import org.smallmind.quorum.pool.connection.remote.RemoteConnectionPoolEventListener;
import org.smallmind.quorum.pool.connection.remote.RemoteConnectionPoolSurface;
import org.smallmind.quorum.pool.connection.remote.RemoteConnectionPoolSurfaceImpl;
import org.smallmind.quorum.transport.remote.RemoteEndpointBinder;
import org.smallmind.quorum.transport.remote.RemoteProxyFactory;

public class ConnectionPoolMonitor
extends NotificationBroadcasterSupport
implements ConnectionPoolMonitorMXBean,
MBeanRegistration,
ConnectionPoolEventListener {
    private ObjectName objectName;
    private RemoteConnectionPoolSurface remoteSurface;
    private ConnectionPoolEventListener remoteListener;
    private String registryName;

    public ConnectionPoolMonitor(ConnectionPool connectionPool, String registryName) throws UnknownHostException, NoSuchMethodException, MalformedURLException, RemoteException, NamingException {
        this(connectionPool, InetAddress.getLocalHost().getHostAddress(), registryName);
    }

    public ConnectionPoolMonitor(ConnectionPool connectionPool, String hostName, String registryName) throws UnknownHostException, NoSuchMethodException, MalformedURLException, RemoteException, NamingException {
        super(new MBeanNotificationInfo(new String[]{"ERROR_OCCURRED"}, ConnectionErrorOccurredNotification.class.getName(), "Connection Error Occurred"), new MBeanNotificationInfo(new String[]{"LEASE_TIME"}, ConnectionLeaseTimeNotification.class.getName(), "Connection Lease Time"));
        this.registryName = registryName;
        RemoteEndpointBinder.bind(new RemoteConnectionPoolSurfaceImpl(connectionPool), registryName);
        this.remoteSurface = RemoteProxyFactory.generateRemoteProxy(RemoteConnectionPoolSurface.class, hostName, registryName);
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) throws UnknownHostException, NoSuchMethodException, MalformedURLException, RemoteException, NamingException {
        RemoteEndpointBinder.bind(new RemoteConnectionPoolEventListener(this), String.valueOf(this.registryName) + ".listener");
        this.remoteListener = RemoteProxyFactory.generateRemoteProxy(ConnectionPoolEventListener.class, String.valueOf(this.registryName) + ".listener");
        this.remoteSurface.addConnectionPoolEventListener(this.remoteListener);
        this.objectName = objectName;
        return this.objectName;
    }

    @Override
    public void postRegister(Boolean success) {
    }

    @Override
    public void preDeregister() throws MalformedURLException, NotBoundException, RemoteException {
        this.remoteSurface.removeConnectionPoolEventListener(this.remoteListener);
        RemoteEndpointBinder.unbind(String.valueOf(this.registryName) + ".listener");
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void reportConnectionErrorOccurred(ErrorReportingConnectionPoolEvent event) {
        this.sendNotification(new ConnectionErrorOccurredNotification(this.objectName, event.getException()));
    }

    @Override
    public void reportConnectionLeaseTime(LeaseTimeReportingConnectionPoolEvent event) {
        this.sendNotification(new ConnectionLeaseTimeNotification(this.objectName, event.getLeaseTimeNanos()));
    }

    @Override
    public String getPoolName() {
        return this.remoteSurface.getPoolName();
    }

    @Override
    public void startup() throws ConnectionPoolException {
        this.remoteSurface.startup();
    }

    @Override
    public void shutdown() throws ConnectionPoolException {
        this.remoteSurface.shutdown();
    }

    @Override
    public boolean isTestOnConnect() {
        return this.remoteSurface.isTestOnConnect();
    }

    @Override
    public void setTestOnConnect(boolean testOnConnect) {
        this.remoteSurface.setTestOnConnect(testOnConnect);
    }

    @Override
    public boolean isTestOnAcquire() {
        return this.remoteSurface.isTestOnAcquire();
    }

    @Override
    public void setTestOnAcquire(boolean testOnAcquire) {
        this.remoteSurface.setTestOnAcquire(testOnAcquire);
    }

    @Override
    public boolean isReportLeaseTimeNanos() {
        return this.remoteSurface.isReportLeaseTimeNanos();
    }

    @Override
    public void setReportLeaseTimeNanos(boolean reportLeaseTimeNanos) {
        this.remoteSurface.setReportLeaseTimeNanos(reportLeaseTimeNanos);
    }

    @Override
    public boolean isExistentiallyAware() {
        return this.remoteSurface.isExistentiallyAware();
    }

    @Override
    public void setExistentiallyAware(boolean existentiallyAware) {
        this.remoteSurface.setExistentiallyAware(existentiallyAware);
    }

    @Override
    public long getConnectionTimeoutMillis() {
        return this.remoteSurface.getConnectionTimeoutMillis();
    }

    @Override
    public void setConnectionTimeoutMillis(long connectionTimeoutMillis) {
        this.remoteSurface.setConnectionTimeoutMillis(connectionTimeoutMillis);
    }

    @Override
    public int getInitialPoolSize() {
        return this.remoteSurface.getInitialPoolSize();
    }

    @Override
    public int getMinPoolSize() {
        return this.remoteSurface.getMinPoolSize();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) {
        this.remoteSurface.setMinPoolSize(minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.remoteSurface.getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        this.remoteSurface.setMaxPoolSize(maxPoolSize);
    }

    @Override
    public synchronized long getAcquireWaitTimeMillis() {
        return this.remoteSurface.getAcquireWaitTimeMillis();
    }

    @Override
    public synchronized void setAcquireWaitTimeMillis(long acquireWaitTimeMillis) {
        this.remoteSurface.setAcquireWaitTimeMillis(acquireWaitTimeMillis);
    }

    @Override
    public int getMaxLeaseTimeSeconds() {
        return this.remoteSurface.getMaxLeaseTimeSeconds();
    }

    @Override
    public void setMaxLeaseTimeSeconds(int leaseTimeSeconds) {
        this.remoteSurface.setMaxLeaseTimeSeconds(leaseTimeSeconds);
    }

    @Override
    public int getMaxIdleTimeSeconds() {
        return this.remoteSurface.getMaxIdleTimeSeconds();
    }

    @Override
    public void setMaxIdleTimeSeconds(int maxIdleTimeSeconds) {
        this.remoteSurface.setMaxIdleTimeSeconds(maxIdleTimeSeconds);
    }

    @Override
    public int getUnReturnedElementTimeoutSeconds() {
        return this.remoteSurface.getUnReturnedElementTimeoutSeconds();
    }

    @Override
    public void setUnReturnedElementTimeoutSeconds(int unReturnedElementTimeoutSeconds) {
        this.remoteSurface.setUnReturnedElementTimeoutSeconds(unReturnedElementTimeoutSeconds);
    }

    @Override
    public int getPoolSize() {
        return this.remoteSurface.getPoolSize();
    }

    @Override
    public int getFreeSize() {
        return this.remoteSurface.getFreeSize();
    }

    @Override
    public int getProcessingSize() {
        return this.remoteSurface.getProcessingSize();
    }
}

