/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.smallmind.instrument.ChronometerInstrumentAndReturn;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.ConfigurationProvider;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.quorum.transport.FauxMethod;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessageTransmitter;

public class MessageInvocationHandler
implements InvocationHandler {
    private MessageTransmitter messageTransmitter;
    private Class serviceInterface;

    public MessageInvocationHandler(MessageTransmitter messageTransmitter, Class serviceInterface) {
        this.messageTransmitter = messageTransmitter;
        this.serviceInterface = serviceInterface;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        return InstrumentationManager.execute((InstrumentAndReturn)new ChronometerInstrumentAndReturn<Object>((ConfigurationProvider)TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.INVOCATION.getDisplay()), new MetricProperty("service", this.serviceInterface.getSimpleName()), new MetricProperty("method", method.getName())}){

            public Object withChronometer() throws Exception {
                return MessageInvocationHandler.this.messageTransmitter.sendMessage(new InvocationSignal(ContextFactory.getExpectedContexts((Class)MessageInvocationHandler.this.serviceInterface), new FauxMethod(method), args), MessageInvocationHandler.this.serviceInterface.getName()).getResult();
            }
        });
    }
}

