/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Topic;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessagePolicy;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;
import org.smallmind.quorum.transport.message.ReceptionListener;
import org.smallmind.quorum.transport.message.ReceptionWorker;
import org.smallmind.quorum.transport.message.ReconnectionPolicy;
import org.smallmind.quorum.transport.message.TopicOperator;
import org.smallmind.quorum.transport.message.TransportManagedObjects;

public class MessageReceiver {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ReceptionListener[] receptionListeners;
    private final ReceptionWorker[] receptionWorkers;
    private final ConnectionFactor[] responseConnectionFactors;

    public MessageReceiver(TransportManagedObjects requestManagedObjects, TransportManagedObjects responseManagedObjects, MessagePolicy messagePolicy, ReconnectionPolicy reconnectionPolicy, MessageStrategy messageStrategy, int clusterSize, int concurrencyLimit, MessageTarget ... messageTargets) throws JMSException, TransportException {
        SynchronousQueue<Message> messageRendezvous = new SynchronousQueue<Message>(true);
        HashMap<String, MessageTarget> targetMap = new HashMap<String, MessageTarget>();
        int topicIndex = 0;
        MessageTarget[] messageTargetArray = messageTargets;
        int n = messageTargets.length;
        int n2 = 0;
        while (n2 < n) {
            MessageTarget messageTarget = messageTargetArray[n2];
            targetMap.put(messageTarget.getServiceInterface().getName(), messageTarget);
            ++n2;
        }
        this.receptionListeners = new ReceptionListener[clusterSize];
        int index = 0;
        while (index < this.receptionListeners.length) {
            this.receptionListeners[index] = new ReceptionListener(new ConnectionFactor(requestManagedObjects, messagePolicy, reconnectionPolicy), (Queue)requestManagedObjects.getDestination(), messageRendezvous);
            ++index;
        }
        this.responseConnectionFactors = new ConnectionFactor[clusterSize];
        index = 0;
        while (index < this.responseConnectionFactors.length) {
            this.responseConnectionFactors[index] = new ConnectionFactor(responseManagedObjects, messagePolicy, reconnectionPolicy);
            ++index;
        }
        ConcurrentLinkedQueue<TopicOperator> operatorQueue = new ConcurrentLinkedQueue<TopicOperator>();
        index = 0;
        while (index < Math.max(clusterSize, concurrencyLimit)) {
            operatorQueue.add(new TopicOperator(this.responseConnectionFactors[topicIndex], (Topic)responseManagedObjects.getDestination()));
            if (++topicIndex == this.responseConnectionFactors.length) {
                topicIndex = 0;
            }
            ++index;
        }
        this.receptionWorkers = new ReceptionWorker[concurrencyLimit];
        index = 0;
        while (index < this.receptionWorkers.length) {
            this.receptionWorkers[index] = new ReceptionWorker(messageStrategy, targetMap, messageRendezvous, operatorQueue);
            new Thread(this.receptionWorkers[index]).start();
            ++index;
        }
    }

    public void close() throws JMSException, InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            Object responseConnectionFactor;
            Object[] objectArray = this.receptionListeners;
            int n = this.receptionListeners.length;
            int n2 = 0;
            while (n2 < n) {
                ReceptionListener receptionListener = objectArray[n2];
                receptionListener.close();
                ++n2;
            }
            objectArray = this.responseConnectionFactors;
            n = this.responseConnectionFactors.length;
            n2 = 0;
            while (n2 < n) {
                responseConnectionFactor = objectArray[n2];
                ((ConnectionFactor)responseConnectionFactor).stop();
                ++n2;
            }
            objectArray = this.receptionWorkers;
            n = this.receptionWorkers.length;
            n2 = 0;
            while (n2 < n) {
                Object receptionWorker = objectArray[n2];
                ((ReceptionWorker)receptionWorker).stop();
                ++n2;
            }
            objectArray = this.responseConnectionFactors;
            n = this.responseConnectionFactors.length;
            n2 = 0;
            while (n2 < n) {
                responseConnectionFactor = objectArray[n2];
                ((ConnectionFactor)responseConnectionFactor).close();
                ++n2;
            }
        }
    }
}

