/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageTransmitter;
import org.smallmind.quorum.transport.message.SessionEmployer;

public class TransmissionListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MessageTransmitter messageTransmitter;
    private final ConnectionFactor responseConnectionFactor;
    private final Topic responseTopic;
    private final String selector;

    public TransmissionListener(MessageTransmitter messageTransmitter, ConnectionFactor responseConnectionFactor, Topic responseTopic) throws JMSException {
        this.messageTransmitter = messageTransmitter;
        this.responseConnectionFactor = responseConnectionFactor;
        this.responseTopic = responseTopic;
        this.selector = String.valueOf(MessageProperty.INSTANCE.getKey()) + "='" + messageTransmitter.getInstanceId() + "'";
        responseConnectionFactor.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.responseTopic;
    }

    @Override
    public String getMessageSelector() {
        return this.selector;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.responseConnectionFactor.stop();
            this.responseConnectionFactor.close();
        }
    }

    public void onMessage(Message message) {
        this.messageTransmitter.completeCallback(message);
    }
}

