/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.quorum.cache.CacheException;

public class InternalHashMap<K, V> {
    private static int MAXIMUM_CAPACITY = 0x40000000;
    private Lock readLock;
    private Lock writeLock;
    private ReentrantLock[] stripeLocks;
    private Entry[] table;
    private AtomicInteger size;
    private AtomicInteger threshold;
    private float loadFactor;

    /*
     * Unable to fully structure code
     */
    public InternalHashMap(ReentrantLock[] stripeLocks, int initialCapacity, float loadFactor) throws CacheException {
        block2: {
            super();
            this.size = new AtomicInteger(0);
            capacity = 1;
            this.stripeLocks = stripeLocks;
            this.loadFactor = loadFactor;
            if (initialCapacity < 0) {
                throw new CacheException("Initial capacity(%d) must be >= 0", new Object[]{initialCapacity});
            }
            if (initialCapacity <= InternalHashMap.MAXIMUM_CAPACITY) break block2;
            initialCapacity = InternalHashMap.MAXIMUM_CAPACITY;
            ** GOTO lbl15
        }
        if (!(loadFactor <= 0.0f) && !Float.isNaN(loadFactor)) ** GOTO lbl15
        throw new CacheException("Load factor(%d) must be> 0 and a valid nuumber", new Object[]{Float.valueOf(loadFactor)});
lbl-1000:
        // 1 sources

        {
            capacity <<= 1;
lbl15:
            // 3 sources

            ** while (capacity < initialCapacity || capacity < stripeLocks.length)
        }
lbl16:
        // 1 sources

        this.threshold = new AtomicInteger((int)((float)capacity * loadFactor));
        this.table = new Entry[capacity];
        readWriteLock = new ReentrantReadWriteLock();
        this.readLock = readWriteLock.readLock();
        this.writeLock = readWriteLock.writeLock();
    }

    private static int hash(int h) {
        h ^= h >>> 20 ^ h >>> 12;
        return h ^ h >>> 7 ^ h >>> 4;
    }

    private int indexFor(K key, int h, int length) {
        return (h & length - 1) / this.stripeLocks.length * this.stripeLocks.length + Math.abs(key.hashCode() % this.stripeLocks.length);
    }

    public int size() {
        return this.size.get();
    }

    public boolean isEmpty() {
        return this.size.get() == 0;
    }

    public V get(K key) {
        Entry<K, V> entry = this.getEntry(key);
        return (V)(entry == null ? null : ((Entry)entry).value);
    }

    public boolean containsKey(K key) {
        return this.getEntry(key) != null;
    }

    private Entry<K, V> getEntry(K key) {
        if (key == null) {
            throw new NullPointerException("AbstractCache does not accept null keys");
        }
        int hash = InternalHashMap.hash(key.hashCode());
        this.readLock.lock();
        try {
            Entry entry = this.table[this.indexFor(key, hash, this.table.length)];
            while (entry != null) {
                if (entry.hash == hash && (entry.key == key || key.equals(entry.key))) {
                    Entry entry2 = entry;
                    return entry2;
                }
                entry = entry.next;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    public V put(K key, V value) {
        return this.putEntry(key, value, false);
    }

    public V putIfAbsent(K key, V value) {
        return this.putEntry(key, value, true);
    }

    public V putEntry(K key, V value, boolean onlyIfAbsent) {
        if (key == null) {
            throw new NullPointerException("AbstractCache does not accept null keys");
        }
        int hash = InternalHashMap.hash(key.hashCode());
        this.readLock.lock();
        try {
            int bucketIndex = this.indexFor(key, hash, this.table.length);
            Entry entry = this.table[bucketIndex];
            while (entry != null) {
                if (entry.hash == hash && (entry.key == key || key.equals(entry.key))) {
                    Object prevValue = entry.value;
                    if (!onlyIfAbsent) {
                        entry.value = value;
                    }
                    Object object = prevValue;
                    return (V)object;
                }
                entry = entry.next;
            }
        }
        finally {
            this.readLock.unlock();
        }
        this.addEntry(hash, key, value);
        return null;
    }

    private void addEntry(int hash, K key, V value) {
        this.readLock.lock();
        try {
            int bucketIndex = this.indexFor(key, hash, this.table.length);
            Entry entry = this.table[bucketIndex];
            this.table[bucketIndex] = new Entry<K, V>(hash, key, value, entry);
        }
        finally {
            this.readLock.unlock();
        }
        if (this.size.getAndIncrement() >= this.threshold.get()) {
            this.resize();
        }
    }

    private void resize() {
        this.writeLock.lock();
        try {
            if (this.size.getAndIncrement() >= this.threshold.get()) {
                Entry[] oldTable = this.table;
                int oldCapacity = oldTable.length;
                int newCapacity = oldTable.length * 2;
                if (oldCapacity == MAXIMUM_CAPACITY) {
                    this.threshold.set(Integer.MAX_VALUE);
                } else {
                    Entry[] newTable = new Entry[newCapacity];
                    this.transfer(newTable);
                    this.table = newTable;
                    this.threshold.set((int)((float)newCapacity * this.loadFactor));
                }
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    private void transfer(Entry[] newTable) {
        int newCapacity = newTable.length;
        int count = 0;
        while (count < this.table.length) {
            Entry entry = this.table[count];
            if (entry != null) {
                Entry nextEntry;
                this.table[count] = null;
                do {
                    nextEntry = entry.next;
                    int bucketIndex = this.indexFor(entry.key, entry.hash, newCapacity);
                    entry.next = newTable[bucketIndex];
                    newTable[bucketIndex] = entry;
                } while ((entry = nextEntry) != null);
            }
            ++count;
        }
    }

    public V remove(K key) {
        Entry<K, V> entry = this.removeEntryForKey(key);
        return (V)(entry == null ? null : ((Entry)entry).value);
    }

    private Entry<K, V> removeEntryForKey(K key) {
        if (key == null) {
            return null;
        }
        this.readLock.lock();
        try {
            Entry prevEntry;
            int hash = InternalHashMap.hash(key.hashCode());
            int bucketIndex = this.indexFor(key, hash, this.table.length);
            Entry entry = prevEntry = this.table[bucketIndex];
            while (entry != null) {
                Entry nextEntry = entry.next;
                if (entry.hash == hash && (entry.key == key || key.equals(entry.key))) {
                    this.size.decrementAndGet();
                    if (prevEntry == entry) {
                        this.table[bucketIndex] = nextEntry;
                    } else {
                        prevEntry.next = nextEntry;
                    }
                    Entry entry2 = entry;
                    return entry2;
                }
                prevEntry = entry;
                entry = nextEntry;
            }
            return null;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void clear() {
        this.writeLock.lock();
        try {
            int i = 0;
            while (i < this.table.length) {
                this.table[i] = null;
                ++i;
            }
            this.size.set(0);
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public KeyIterator keyIterator() {
        return new KeyIterator();
    }

    private static class Entry<K, V> {
        private K key;
        private int hash;
        private Entry<K, V> next;
        private V value;

        Entry(int hash, K key, V value, Entry<K, V> next) {
            this.hash = hash;
            this.key = key;
            this.value = value;
            this.next = next;
        }

        public K getKey() {
            return this.key;
        }

        public V getValue() {
            return this.value;
        }

        public V setValue(V newValue) {
            V oldValue = this.value;
            this.value = newValue;
            return oldValue;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Entry) {
                V value2;
                V value1;
                K key2;
                Entry entry = (Entry)obj;
                K key1 = this.getKey();
                if ((key1 == (key2 = entry.getKey()) || key1 != null && key1.equals(key2)) && ((value1 = this.getValue()) == (value2 = entry.getValue()) || value1 != null && value1.equals(value2))) {
                    return true;
                }
            }
            return false;
        }

        public int hashCode() {
            return this.key.hashCode() ^ (this.value == null ? 0 : this.value.hashCode());
        }
    }

    private class KeyIterator
    implements Iterator<K>,
    Iterable<K> {
        Entry<K, V> nextEntry;
        int index = 0;

        KeyIterator() {
            if (InternalHashMap.this.size.get() > 0) {
                this.findNextBucket();
            }
        }

        private void findNextBucket() {
            InternalHashMap.this.writeLock.lock();
            try {
                while (this.index < InternalHashMap.this.table.length) {
                    this.nextEntry = InternalHashMap.this.table[this.index++];
                    if (this.nextEntry == null) continue;
                    break;
                }
            }
            finally {
                InternalHashMap.this.writeLock.unlock();
            }
        }

        @Override
        public Iterator<K> iterator() {
            return this;
        }

        @Override
        public boolean hasNext() {
            return this.nextEntry != null;
        }

        @Override
        public K next() {
            if (this.nextEntry == null) {
                throw new NoSuchElementException();
            }
            ReentrantLock stripeLock = InternalHashMap.this.stripeLocks[Math.abs(this.nextEntry.key.hashCode() % InternalHashMap.this.stripeLocks.length)];
            Entry entry = this.nextEntry;
            stripeLock.lock();
            try {
                InternalHashMap.this.readLock.lock();
                try {
                    this.nextEntry = entry.next;
                }
                finally {
                    InternalHashMap.this.readLock.unlock();
                }
            }
            finally {
                stripeLock.unlock();
            }
            if (this.nextEntry == null) {
                this.findNextBucket();
            }
            return entry.getKey();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

