/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricDestination;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class ReceptionListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ConnectionFactor requestConnectionFactor;
    private final Queue requestQueue;
    private final SynchronousQueue<Message> messageRendezvous;
    private final long ntpOffset;

    public ReceptionListener(ConnectionFactor requestConnectionFactor, Queue requestQueue, SynchronousQueue<Message> messageRendezvous, long ntpOffset) throws JMSException {
        this.requestConnectionFactor = requestConnectionFactor;
        this.requestQueue = requestQueue;
        this.messageRendezvous = messageRendezvous;
        this.ntpOffset = ntpOffset;
        requestConnectionFactor.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.requestQueue;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.requestConnectionFactor.stop();
            this.requestConnectionFactor.close();
        }
    }

    public synchronized void onMessage(final Message message) {
        try {
            long timeInQueue = System.currentTimeMillis() + this.ntpOffset - message.getLongProperty(MessageProperty.TIME.getKey());
            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(timeInQueue >= 0L ? timeInQueue : 0L), (MetricProperty[])new MetricProperty[]{new MetricProperty("destination", MetricDestination.REQUEST_QUEUE.getDisplay())});
            InstrumentationManager.execute((Instrument)new ChronometerInstrument(TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.ACQUIRE_WORKER.getDisplay())}){

                public void withChronometer() throws InterruptedException {
                    boolean success;
                    do {
                        success = ReceptionListener.this.messageRendezvous.offer(message, 1L, TimeUnit.SECONDS);
                    } while (!ReceptionListener.this.closed.get() && !success);
                }
            });
        }
        catch (Exception exception) {
            LoggerManager.getLogger(ReceptionListener.class).error((Throwable)exception);
        }
    }
}

