/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricDestination;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageTransmitter;
import org.smallmind.quorum.transport.message.ReceptionListener;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class TransmissionListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final MessageTransmitter messageTransmitter;
    private final ConnectionFactor responseConnectionFactor;
    private final Topic responseTopic;
    private final String selector;
    private final long ntpOffset;

    public TransmissionListener(MessageTransmitter messageTransmitter, ConnectionFactor responseConnectionFactor, Topic responseTopic, long ntpOffset) throws JMSException {
        this.messageTransmitter = messageTransmitter;
        this.responseConnectionFactor = responseConnectionFactor;
        this.responseTopic = responseTopic;
        this.ntpOffset = ntpOffset;
        this.selector = String.valueOf(MessageProperty.INSTANCE.getKey()) + "='" + messageTransmitter.getInstanceId() + "'";
        responseConnectionFactor.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.responseTopic;
    }

    @Override
    public String getMessageSelector() {
        return this.selector;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.responseConnectionFactor.stop();
            this.responseConnectionFactor.close();
        }
    }

    public void onMessage(final Message message) {
        try {
            long timeInTopic = System.currentTimeMillis() + this.ntpOffset - message.getLongProperty(MessageProperty.TIME.getKey());
            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(timeInTopic >= 0L ? timeInTopic : 0L), (MetricProperty[])new MetricProperty[]{new MetricProperty("destination", MetricDestination.RESPONSE_TOPIC.getDisplay())});
        }
        catch (JMSException jmsException) {
            LoggerManager.getLogger(ReceptionListener.class).error((Throwable)jmsException);
        }
        try {
            InstrumentationManager.execute((Instrument)new ChronometerInstrument(TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.COMPLETE_CALLBACK.getDisplay())}){

                public void withChronometer() {
                    TransmissionListener.this.messageTransmitter.completeCallback(message);
                }
            });
        }
        catch (Exception exception) {
            LoggerManager.getLogger(ReceptionListener.class).error((Throwable)exception);
        }
    }
}

