/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.DelayQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.quorum.cache.CacheException;
import org.smallmind.quorum.cache.CacheLockException;
import org.smallmind.quorum.cache.KeyLock;
import org.smallmind.quorum.cache.LockedCallback;
import org.smallmind.quorum.cache.LockingCache;
import org.terracotta.annotations.InstrumentedClass;

@InstrumentedClass
public abstract class LockingCacheEnforcer<K, V>
implements LockingCache<K, V> {
    private static final ForcedUnlockTimer FORCED_UNLOCK_TIMER = new ForcedUnlockTimer();
    private final ConcurrentHashMap<K, KeyCondition<K>> keyConditionMap;
    private final ReentrantLock[] stripeLocks;
    private long lockTimeout;

    static {
        Thread forcedUnlockTimerThread = new Thread(FORCED_UNLOCK_TIMER);
        forcedUnlockTimerThread.setDaemon(true);
        forcedUnlockTimerThread.start();
    }

    public LockingCacheEnforcer(ReentrantLock[] stripeLocks, long lockTimeout) throws CacheException {
        if (stripeLocks.length % 2 != 0) {
            throw new CacheException("Concurrency level(%d) must be an even power of 2", stripeLocks.length);
        }
        this.stripeLocks = stripeLocks;
        this.lockTimeout = lockTimeout;
        this.keyConditionMap = new ConcurrentHashMap(stripeLocks.length, 0.75f, stripeLocks.length);
    }

    @Override
    public long getLockTimeout() {
        return this.lockTimeout;
    }

    @Override
    public <R> R executeLockedCallback(KeyLock keyLock, LockedCallback<K, R> callback) {
        ReentrantLock stripeLock = this.lockStripe(callback.getKey());
        try {
            this.gateKey(keyLock, callback.getKey());
            R r = callback.execute();
            return r;
        }
        finally {
            stripeLock.unlock();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public KeyLock lock(KeyLock keyLock, K key) {
        KeyCondition<K> keyCondition;
        ReentrantLock stripeLock;
        block8: {
            stripeLock = this.lockStripe(key);
            try {
                keyCondition = this.keyConditionMap.get(key);
                if (keyCondition == null) {
                    keyCondition = new KeyCondition<K>(this, key, this.lockTimeout);
                    this.keyConditionMap.put(key, keyCondition);
                    KeyLock keyLock2 = keyCondition.getOwningKeyLock();
                    stripeLock.unlock();
                    return keyLock2;
                }
            }
            catch (Throwable throwable) {
                stripeLock.unlock();
                throw throwable;
            }
            {
                if (keyLock == null || !keyCondition.isOwnedByKeyLock(keyLock)) break block8;
                KeyLock keyLock3 = keyCondition.inc();
                stripeLock.unlock();
                return keyLock3;
            }
        }
        while (true) {
            if ((keyCondition = this.keyConditionMap.get(key)) == null) break;
            try {
                keyCondition.getCondition().await();
            }
            catch (InterruptedException interruptedException) {
                throw new CacheLockException(interruptedException, "Interrupted while awaiting a lock opportunity on key(%s)", key.toString());
            }
        }
        keyCondition = new KeyCondition<K>(this, key, this.lockTimeout);
        this.keyConditionMap.put(key, keyCondition);
        KeyLock keyLock4 = keyCondition.getOwningKeyLock();
        stripeLock.unlock();
        return keyLock4;
    }

    @Override
    public void unlock(KeyLock keyLock, K key) {
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            KeyCondition<K> keyCondition = this.keyConditionMap.get(key);
            if (keyCondition == null) {
                throw new CacheLockException("Attempt to unlock key(%s), but the lock has already expired - try increasing the lock time out", key.toString());
            }
            if (!keyCondition.isOwnedByKeyLock(keyLock)) {
                throw new CacheLockException("Attempt to unlock key(%s) owned by lock(%s) by a non-owning lock(%s)", key.toString(), keyCondition.getOwningKeyLock().getName(), keyLock == null ? "null" : keyLock.getName());
            }
            keyCondition.dec();
        }
        finally {
            stripeLock.unlock();
        }
    }

    protected ReentrantLock[] getStripeLockArray() {
        return this.stripeLocks;
    }

    protected ReentrantLock lockStripe(K key) {
        ReentrantLock stripeLock = this.stripeLocks[Math.abs(key.hashCode() % this.stripeLocks.length)];
        stripeLock.lock();
        return stripeLock;
    }

    protected void gateKey(KeyLock keyLock, K key) {
        KeyCondition<K> keyCondition;
        while ((keyCondition = this.keyConditionMap.get(key)) != null && !keyCondition.isOwnedByKeyLock(keyLock)) {
            try {
                keyCondition.getCondition().await();
            }
            catch (InterruptedException interruptedException) {
                throw new CacheLockException(interruptedException, "Interrupted while awaiting the stripeLock on key(%s)", key.toString());
            }
        }
    }

    private Condition createCondition(K key) {
        return this.stripeLocks[Math.abs(key.hashCode() % this.stripeLocks.length)].newCondition();
    }

    private KeyCondition<K> retrieveGatedKeyCondition(K key) {
        return this.keyConditionMap.remove(key);
    }

    private static class ForcedUnlockTimer
    implements Runnable {
        private CountDownLatch exitLatch;
        private DelayQueue<KeyCondition> forcedUnlockQueue;
        private AtomicBoolean finished = new AtomicBoolean(false);

        public ForcedUnlockTimer() {
            this.forcedUnlockQueue = new DelayQueue();
            this.exitLatch = new CountDownLatch(1);
        }

        public void add(KeyCondition keyCondition) {
            this.forcedUnlockQueue.add(keyCondition);
        }

        public void remove(KeyCondition keyCondition) {
            this.forcedUnlockQueue.remove(keyCondition);
        }

        public void finish() throws InterruptedException {
            this.finished.set(true);
            this.exitLatch.await();
        }

        /*
         * Exception decompiling
         */
        @Override
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }
    }

    @InstrumentedClass
    private static class KeyCondition<K>
    implements Delayed {
        private KeyLock keyLock;
        private LockingCacheEnforcer<K, ?> lockingCache;
        private K key;
        private Condition condition;
        private AtomicBoolean terminated = new AtomicBoolean(false);
        private boolean timed;
        private long unlockTarget;
        private int lockCount = 1;

        public KeyCondition(LockingCacheEnforcer<K, ?> lockingCache, K key, long externalLockTimeout) {
            this.lockingCache = lockingCache;
            this.key = key;
            this.keyLock = new KeyLock();
            this.condition = ((LockingCacheEnforcer)lockingCache).createCondition(key);
            this.timed = externalLockTimeout > 0L;
            if (this.timed) {
                this.unlockTarget = System.currentTimeMillis() + externalLockTimeout;
                FORCED_UNLOCK_TIMER.add(this);
            }
        }

        public KeyLock getOwningKeyLock() {
            return this.keyLock;
        }

        public boolean isOwnedByKeyLock(KeyLock keyLock) {
            return this.keyLock.equals(keyLock);
        }

        public Condition getCondition() {
            return this.condition;
        }

        public long getUnlockTarget() {
            if (!this.timed) {
                throw new UnsupportedOperationException("No external lock timeout was specified");
            }
            return this.unlockTarget;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            if (!this.timed) {
                throw new UnsupportedOperationException("No external lock timeout was specified");
            }
            return unit.convert(this.unlockTarget - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        }

        @Override
        public int compareTo(Delayed delayed) {
            if (!this.timed) {
                throw new UnsupportedOperationException("No external lock timeout was specified");
            }
            return (int)(this.unlockTarget - ((KeyCondition)delayed).getUnlockTarget());
        }

        public KeyLock inc() {
            ++this.lockCount;
            return this.keyLock;
        }

        public void dec() {
            if (--this.lockCount == 0) {
                if (this.timed) {
                    FORCED_UNLOCK_TIMER.remove(this);
                }
                this.terminate();
            }
        }

        public void terminate() {
            if (this.terminated.compareAndSet(false, true)) {
                ReentrantLock stripeLock = this.lockingCache.lockStripe(this.key);
                try {
                    ((LockingCacheEnforcer)this.lockingCache).retrieveGatedKeyCondition(this.key).getCondition().signalAll();
                }
                finally {
                    stripeLock.unlock();
                }
            }
        }
    }
}

