/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.pool.PoolManager;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.DeconstructionCoordinator;
import org.smallmind.quorum.pool.complex.DeconstructionQueue;
import org.smallmind.quorum.pool.instrument.MetricEvent;

public class ComponentPin<C> {
    private final ComponentPool<C> componentPool;
    private final ComponentInstance<C> componentInstance;
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private DeconstructionCoordinator deconstructionCoordinator;
    private long leaseStartNanos;

    protected ComponentPin(ComponentPool<C> componentPool, DeconstructionQueue deconstructionQueue, ComponentInstance<C> componentInstance) {
        this.componentPool = componentPool;
        this.componentInstance = componentInstance;
        if (componentPool.getComplexPoolConfig().requiresDeconstruction()) {
            this.deconstructionCoordinator = new DeconstructionCoordinator(componentPool, deconstructionQueue, this);
            this.deconstructionCoordinator.free();
        }
    }

    protected ComponentInstance<C> getComponentInstance() {
        return this.componentInstance;
    }

    protected C serve() throws Exception {
        try {
            C c = this.componentInstance.serve();
            return c;
        }
        finally {
            if (this.deconstructionCoordinator != null) {
                this.deconstructionCoordinator.serve();
            }
            this.leaseStartNanos = Clocks.EPOCH.getClock().getTimeNanoseconds();
        }
    }

    protected void free() {
        long leaseTime = Clocks.EPOCH.getClock().getTimeNanoseconds() - this.leaseStartNanos;
        if (this.componentPool.getComplexPoolConfig().isReportLeaseTimeNanos()) {
            this.componentPool.reportLeaseTimeNanos(leaseTime);
        }
        InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)PoolManager.getPool(), (long)leaseTime, (TimeUnit)TimeUnit.NANOSECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("event", MetricEvent.PROCESSING.getDisplay())});
        if (this.deconstructionCoordinator != null) {
            this.deconstructionCoordinator.free();
        }
    }

    protected boolean isTerminated() {
        return this.terminated.get();
    }

    protected void fizzle() {
        if (this.terminated.compareAndSet(false, true) && this.deconstructionCoordinator != null) {
            this.deconstructionCoordinator.abort();
        }
    }

    protected void kaboom(boolean withPrejudice) {
        if (this.terminated.compareAndSet(false, true)) {
            this.componentPool.removePin(this, withPrejudice);
        }
    }

    public StackTraceElement[] getExistentialStackTrace() {
        return this.componentInstance.getExistentialStackTrace();
    }
}

