/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.io.Serializable;
import javax.jms.Message;
import javax.jms.Session;
import org.smallmind.instrument.ChronometerInstrumentAndReturn;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MethodInvoker;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;

public class InvocationMessageTarget
implements MessageTarget {
    private MethodInvoker methodInvoker;
    private Class serviceInterface;

    public InvocationMessageTarget(Object targetObject, Class serviceInterface) throws NoSuchMethodException {
        this.serviceInterface = serviceInterface;
        this.methodInvoker = new MethodInvoker(targetObject, new Class[]{this.serviceInterface});
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public Message handleMessage(final Session session, final MessageStrategy messageStrategy, Message message) throws Exception {
        final InvocationSignal invocationSignal = (InvocationSignal)messageStrategy.unwrapFromMessage(message);
        final Serializable result = (Serializable)InstrumentationManager.execute((InstrumentAndReturn)new ChronometerInstrumentAndReturn<Serializable>((MetricConfigurationProvider)TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.INVOCATION.getDisplay()), new MetricProperty("service", this.serviceInterface.getSimpleName()), new MetricProperty("method", invocationSignal.getFauxMethod().getName())}){

            public Serializable withChronometer() throws Exception {
                return (Serializable)InvocationMessageTarget.this.methodInvoker.remoteInvocation(invocationSignal);
            }
        });
        return (Message)InstrumentationManager.execute((InstrumentAndReturn)new ChronometerInstrumentAndReturn<Message>((MetricConfigurationProvider)TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.CONSTRUCT_MESSAGE.getDisplay())}){

            public Message withChronometer() throws Exception {
                return messageStrategy.wrapInMessage(session, result);
            }
        });
    }
}

