/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.remote;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.rmi.PortableRemoteObject;
import org.smallmind.quorum.transport.remote.RemoteInvocationHandler;
import org.smallmind.quorum.transport.remote.RemoteTarget;

public class RemoteProxyFactory {
    public static <C> C generateRemoteProxy(Class<C> endpointInterface, String registryName) throws UnknownHostException, NoSuchMethodException, NamingException, RemoteException {
        return RemoteProxyFactory.generateRemoteProxy(endpointInterface, InetAddress.getLocalHost().getHostAddress(), registryName);
    }

    public static <C> C generateRemoteProxy(Class<C> endpointInterface, String hostName, String registryName) throws NoSuchMethodException, NamingException, RemoteException {
        InitialContext initContext = new InitialContext();
        Context rmiContext = (Context)initContext.lookup("rmi://" + hostName);
        RemoteTarget remoteTarget = (RemoteTarget)PortableRemoteObject.narrow((Object)rmiContext.lookup(registryName), RemoteTarget.class);
        rmiContext.close();
        initContext.close();
        return endpointInterface.cast(Proxy.newProxyInstance(RemoteInvocationHandler.class.getClassLoader(), new Class[]{endpointInterface}, (InvocationHandler)new RemoteInvocationHandler(endpointInterface, remoteTarget)));
    }
}

