/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.jms.Message;
import org.smallmind.quorum.transport.TransportTimeoutException;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.TransmissionCallback;

public class AsynchronousTransmissionCallback
implements TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<Message> responseMessageRef = new AtomicReference();
    private final MessageStrategy messageStrategy;
    private final long timeoutSeconds;

    public AsynchronousTransmissionCallback(MessageStrategy messageStrategy, long timeoutSeconds) {
        this.messageStrategy = messageStrategy;
        this.timeoutSeconds = timeoutSeconds;
    }

    public void destroy() {
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult() throws Exception {
        this.resultLatch.await();
        Message responseMessage = this.responseMessageRef.get();
        if (responseMessage == null) {
            throw new TransportTimeoutException("The timeout(%d) seconds was exceeded while waiting for a response", this.timeoutSeconds);
        }
        if (responseMessage.getBooleanProperty(MessageProperty.EXCEPTION.getKey())) {
            throw (Exception)this.messageStrategy.unwrapFromMessage(responseMessage);
        }
        return this.messageStrategy.unwrapFromMessage(responseMessage);
    }

    public void setResponseMessage(Message responseMessage) {
        this.responseMessageRef.set(responseMessage);
        this.resultLatch.countDown();
    }
}

