/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.jms.Connection;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.Session;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.MessagePolicy;
import org.smallmind.quorum.transport.message.ReconnectionPolicy;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.quorum.transport.message.TransportManagedObjects;
import org.smallmind.scribe.pen.LoggerManager;

public class ConnectionFactor
implements ExceptionListener {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private final TransportManagedObjects managedObjects;
    private final MessagePolicy messagePolicy;
    private final ReconnectionPolicy reconnectionPolicy;
    private final ConcurrentHashMap<SessionEmployer, Session> sessionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<SessionEmployer, MessageProducer> producerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<SessionEmployer, MessageConsumer> consumerMap = new ConcurrentHashMap();
    private Connection connection;

    public ConnectionFactor(TransportManagedObjects managedObjects, MessagePolicy messagePolicy, ReconnectionPolicy reconnectionPolicy) throws TransportException, JMSException {
        this.managedObjects = managedObjects;
        this.messagePolicy = messagePolicy;
        this.reconnectionPolicy = reconnectionPolicy;
        this.createConnection();
    }

    private void createConnection() throws TransportException, JMSException {
        if (this.connection != null) {
            try {
                this.connection.stop();
                this.connection.close();
            }
            catch (JMSException jmsException) {
                LoggerManager.getLogger(ConnectionFactor.class).error((Throwable)jmsException);
            }
        }
        this.connection = this.managedObjects.createConnection();
        this.connection.setExceptionListener((ExceptionListener)this);
    }

    public Session getSession(SessionEmployer sessionEmployer) throws JMSException {
        Session session;
        this.lock.readLock().lock();
        try {
            session = this.sessionMap.get(sessionEmployer);
            if (session == null) {
                session = this.connection.createSession(false, this.messagePolicy.getAcknowledgeMode().getJmsValue());
                this.sessionMap.put(sessionEmployer, session);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return session;
    }

    public MessageProducer getProducer(SessionEmployer sessionEmployer) throws JMSException {
        MessageProducer producer;
        this.lock.readLock().lock();
        try {
            producer = this.producerMap.get(sessionEmployer);
            if (producer == null) {
                producer = this.getSession(sessionEmployer).createProducer(sessionEmployer.getDestination());
                this.producerMap.put(sessionEmployer, producer);
                this.messagePolicy.apply(producer);
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return producer;
    }

    public void createConsumer(SessionEmployer sessionEmployer) throws JMSException {
        this.lock.readLock().lock();
        try {
            String selector = sessionEmployer.getMessageSelector();
            MessageConsumer consumer = selector == null ? this.getSession(sessionEmployer).createConsumer(sessionEmployer.getDestination()) : this.getSession(sessionEmployer).createConsumer(sessionEmployer.getDestination(), selector, false);
            this.consumerMap.put(sessionEmployer, consumer);
            consumer.setMessageListener((MessageListener)sessionEmployer);
            this.connection.start();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void stop() throws JMSException {
        if (this.connection != null) {
            this.connection.stop();
        }
    }

    public void close() throws JMSException {
        if (this.connection != null) {
            for (MessageProducer producer : this.producerMap.values()) {
                producer.close();
            }
            for (MessageConsumer consumer : this.consumerMap.values()) {
                consumer.close();
            }
            for (Session session : this.sessionMap.values()) {
                session.close();
            }
            this.connection.close();
        }
    }

    public void onException(JMSException jmsException) {
        this.lock.writeLock().lock();
        try {
            Exception lastException = null;
            boolean success = false;
            int reconnectionCount = 0;
            LoggerManager.getLogger(ConnectionFactor.class).error((Throwable)jmsException);
            while (!(success || this.reconnectionPolicy.getReconnectionAttempts() >= 0 && reconnectionCount++ >= this.reconnectionPolicy.getReconnectionAttempts())) {
                try {
                    Thread.sleep(this.reconnectionPolicy.getReconnectionDelayMilliseconds());
                    this.createConnection();
                    this.sessionMap.clear();
                    this.producerMap.clear();
                    for (SessionEmployer sessionEmployer : this.consumerMap.keySet()) {
                        this.createConsumer(sessionEmployer);
                    }
                    success = true;
                }
                catch (Exception exception) {
                    lastException = exception;
                }
            }
            if (success) {
                LoggerManager.getLogger(ConnectionFactor.class).info((Object)"Successful reconnection after JMS provider failure");
            } else {
                TransportException transportException = new TransportException("Unable to reconnection within max attempts(%d)", this.reconnectionPolicy.getReconnectionAttempts());
                LoggerManager.getLogger(ConnectionFactor.class).error((Throwable)(lastException != null ? transportException.initCause(lastException) : transportException));
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

