/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.smallmind.quorum.cache.KeyLock;
import org.smallmind.quorum.cache.LockableCache;
import org.smallmind.quorum.cache.LockedCallback;
import org.smallmind.quorum.cache.LockingCache;

public class LockableCacheEnforcer<K, V>
implements LockableCache<K, V> {
    private static final InheritableThreadLocal<Map<Object, KeyLock>> KEY_LOCK_MAP_LOCAL = new InheritableThreadLocal<Map<Object, KeyLock>>(){

        @Override
        protected Map<Object, KeyLock> initialValue() {
            return new ConcurrentHashMap<Object, KeyLock>();
        }
    };
    private LockingCache<K, V> cache;

    public LockableCacheEnforcer(LockingCache<K, V> cache) {
        this.cache = cache;
    }

    @Override
    public long getLockTimeout() {
        return this.cache.getLockTimeout();
    }

    @Override
    public void lock(K key) {
        ((Map)KEY_LOCK_MAP_LOCAL.get()).put(key, this.cache.lock((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key));
    }

    @Override
    public void unlock(K key) {
        this.cache.unlock((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).remove(key), key);
    }

    @Override
    public <R> R executeLockedCallback(LockedCallback<K, R> callback) {
        return this.cache.executeLockedCallback((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(callback.getKey()), callback);
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public String getCacheName() {
        return this.cache.getCacheName();
    }

    @Override
    public V get(K key, Object ... parameters) {
        return this.cache.get((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key, parameters);
    }

    @Override
    public V remove(K key) {
        return this.cache.remove((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key);
    }

    @Override
    public V put(K key, V value) {
        return this.cache.put((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key, value);
    }

    @Override
    public V putIfAbsent(K key, V value) {
        return this.cache.putIfAbsent((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key, value);
    }

    @Override
    public boolean exists(K key) {
        return this.cache.exists((KeyLock)((Map)KEY_LOCK_MAP_LOCAL.get()).get(key), key);
    }

    @Override
    public void clear() {
        this.cache.clear();
    }

    @Override
    public boolean isClosed() {
        return this.cache.isClosed();
    }

    @Override
    public void close() {
        this.cache.close();
    }
}

