/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.quorum.cache.CacheException;
import org.smallmind.quorum.cache.KeyLock;
import org.smallmind.quorum.cache.LockingCache;
import org.smallmind.quorum.cache.LockingCacheEnforcer;
import org.smallmind.quorum.cache.StripeLockFactory;
import org.smallmind.quorum.cache.indigenous.CacheEntry;
import org.smallmind.quorum.cache.indigenous.CacheExpirationPolicy;
import org.smallmind.quorum.cache.indigenous.CacheReference;
import org.smallmind.quorum.cache.indigenous.CacheSource;
import org.smallmind.quorum.cache.indigenous.CacheValidationPolicy;
import org.smallmind.quorum.cache.indigenous.ExpirationTimer;
import org.smallmind.quorum.cache.indigenous.InternalHashMap;

public abstract class AbstractCache<K, V, E extends CacheEntry<V>>
extends LockingCacheEnforcer<K, V>
implements LockingCache<K, V> {
    private transient ExpirationTimer<K> expirationTimer;
    private InternalHashMap<K, E> cacheReferenceMap;
    private CacheSource<K, V, E> cacheSource;
    private CacheExpirationPolicy<E> cacheExpirationPolicy;
    private String cacheName;
    private AtomicBoolean closed = new AtomicBoolean(false);

    public AbstractCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheExpirationPolicy<E> cacheExpirationPolicy, int initialCapacity, float loadFactor, int concurrencyLevel, long externalLockTimeout) throws CacheException {
        super(StripeLockFactory.createStripeLockArray(concurrencyLevel), externalLockTimeout);
        this.cacheName = cacheName;
        this.cacheSource = cacheSource;
        this.cacheExpirationPolicy = cacheExpirationPolicy;
        this.cacheReferenceMap = new InternalHashMap(this.getStripeLockArray(), initialCapacity, loadFactor);
        if (cacheExpirationPolicy != null && cacheExpirationPolicy.getTimerTickSeconds() > 0) {
            this.expirationTimer = new ExpirationTimer(this, cacheExpirationPolicy.getTimerTickSeconds());
            Thread expirationTimerThread = new Thread(this.expirationTimer);
            expirationTimerThread.setDaemon(true);
            expirationTimerThread.start();
        }
    }

    @Override
    public abstract V get(KeyLock var1, K var2, Object ... var3) throws CacheException;

    @Override
    public abstract V remove(KeyLock var1, K var2) throws CacheException;

    protected Iterator<K> getKeyIterator() {
        if (this.closed.get()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        return this.cacheReferenceMap.keyIterator();
    }

    protected E expireEntry(K key) {
        CacheEntry cacheEntry = (CacheEntry)this.cacheReferenceMap.remove(key);
        if (cacheEntry != null) {
            cacheEntry.expire();
        }
        return (E)cacheEntry;
    }

    protected E getExistingEntry(KeyLock keyLock, K key) throws CacheException {
        E cacheEntry = this.retrieveEntry(keyLock, key);
        if (cacheEntry != null) {
            cacheEntry.cacheHit();
            return cacheEntry;
        }
        return null;
    }

    protected E createNewEntry(K key, Object ... parameters) throws CacheException {
        E cacheEntry = this.cacheSource.createEntry(key, parameters);
        if (cacheEntry != null) {
            this.implantReference(new CacheReference<K, E>(key, cacheEntry));
            return cacheEntry;
        }
        return null;
    }

    protected E retrieveEntry(KeyLock keyLock, K key) throws CacheException {
        CacheEntry cacheEntry = (CacheEntry)this.cacheReferenceMap.get(key);
        if (cacheEntry != null) {
            if (this.cacheExpirationPolicy != null && this.cacheExpirationPolicy.isStale(cacheEntry)) {
                this.remove(keyLock, key);
                return null;
            }
            return (E)cacheEntry;
        }
        return null;
    }

    protected E implantReference(CacheReference<K, E> cacheReference) throws CacheException {
        return (E)((CacheEntry)this.cacheReferenceMap.put(cacheReference.getKey(), cacheReference.getCacheEntry()));
    }

    @Override
    public String getCacheName() {
        return this.cacheName;
    }

    @Override
    public int size() {
        return this.cacheReferenceMap.size();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void validate(KeyLock keyLock, CacheValidationPolicy<E> cacheValidationPolicy) throws CacheException {
        if (this.closed.get()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        for (Object key : this.cacheReferenceMap.keyIterator()) {
            ReentrantLock stripeLock = this.lockStripe(key);
            try {
                this.gateKey(keyLock, key);
                CacheEntry cacheEntry = (CacheEntry)this.cacheReferenceMap.get(key);
                if (cacheEntry == null || cacheValidationPolicy.isValid(cacheEntry)) continue;
                this.remove(keyLock, key);
            }
            finally {
                stripeLock.unlock();
            }
        }
    }

    @Override
    public boolean exists(KeyLock keyLock, K key) throws CacheException {
        if (this.closed.get()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            boolean bl = this.retrieveEntry(keyLock, key) != null;
            return bl;
        }
        finally {
            stripeLock.unlock();
        }
    }

    @Override
    public V put(KeyLock keyLock, K key, V value) throws CacheException {
        if (this.closed.get()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            E cacheEntry = this.implantReference(this.cacheSource.wrapReference(key, value));
            if (cacheEntry != null) {
                Object v = cacheEntry.getEntry();
                return v;
            }
            return null;
        }
        finally {
            stripeLock.unlock();
        }
    }

    @Override
    public V putIfAbsent(KeyLock keyLock, K key, V value) {
        if (this.closed.get()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            E cacheEntry = this.retrieveEntry(keyLock, key);
            if (cacheEntry == null) {
                this.implantReference(this.cacheSource.wrapReference(key, value));
                return null;
            }
            Object v = cacheEntry.getEntry();
            return v;
        }
        finally {
            stripeLock.unlock();
        }
    }

    @Override
    public boolean isClosed() {
        return this.closed.get();
    }

    @Override
    public void close() {
        if (this.closed.compareAndSet(false, true) && this.expirationTimer != null) {
            this.expirationTimer.finish();
        }
    }
}

