/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.cache.indigenous;

import java.util.concurrent.locks.ReentrantLock;
import org.smallmind.quorum.cache.CacheException;
import org.smallmind.quorum.cache.KeyLock;
import org.smallmind.quorum.cache.indigenous.AbstractCache;
import org.smallmind.quorum.cache.indigenous.CacheEntry;
import org.smallmind.quorum.cache.indigenous.CacheExpirationPolicy;
import org.smallmind.quorum.cache.indigenous.CacheSource;

public class UnorderedCache<K, V, E extends CacheEntry<V>>
extends AbstractCache<K, V, E> {
    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource) throws CacheException {
        this(cacheName, cacheSource, null, 16, 0.75f, 16, 0L);
    }

    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource, int initialCapacity, float loadFactor, int concurrencyLevel) throws CacheException {
        this(cacheName, cacheSource, null, initialCapacity, loadFactor, concurrencyLevel, 0L);
    }

    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource, int initialCapacity, float loadFactor, int concurrencyLevel, long externalLockTimeout) throws CacheException {
        this(cacheName, cacheSource, null, initialCapacity, loadFactor, concurrencyLevel, externalLockTimeout);
    }

    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheExpirationPolicy<E> cacheExpirationPolicy) throws CacheException {
        this(cacheName, cacheSource, cacheExpirationPolicy, 16, 0.75f, 16, 0L);
    }

    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheExpirationPolicy<E> cacheExpirationPolicy, int initialCapacity, float loadFactor, int concurrencyLevel) throws CacheException {
        this(cacheName, cacheSource, cacheExpirationPolicy, initialCapacity, loadFactor, concurrencyLevel, 0L);
    }

    public UnorderedCache(String cacheName, CacheSource<K, V, E> cacheSource, CacheExpirationPolicy<E> cacheExpirationPolicy, int initialCapacity, float loadFactor, int concurrencyLevel, long externalLockTimeout) throws CacheException {
        super(cacheName, cacheSource, cacheExpirationPolicy, initialCapacity, loadFactor, concurrencyLevel, externalLockTimeout);
    }

    @Override
    public V remove(KeyLock keyLock, K key) {
        if (this.isClosed()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            Object cacheEntry = this.expireEntry(key);
            if (cacheEntry != null) {
                Object v = cacheEntry.getEntry();
                return v;
            }
            return null;
        }
        finally {
            stripeLock.unlock();
        }
    }

    @Override
    public V get(KeyLock keyLock, K key, Object ... parameters) throws CacheException {
        if (this.isClosed()) {
            throw new IllegalStateException("The AbstractCache has been previously closed()");
        }
        ReentrantLock stripeLock = this.lockStripe(key);
        try {
            this.gateKey(keyLock, key);
            Object cacheEntry = this.getExistingEntry(keyLock, key);
            if (cacheEntry != null) {
                Object v = cacheEntry.getEntry();
                return v;
            }
            cacheEntry = this.createNewEntry(key, parameters);
            if (cacheEntry != null) {
                Object v = cacheEntry.getEntry();
                return v;
            }
            return null;
        }
        finally {
            stripeLock.unlock();
        }
    }
}

