/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Topic;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricDestination;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.QueueOperator;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class GossipListener
implements SessionEmployer,
MessageListener {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ConnectionFactor gossipConnectionFactor;
    private final Topic gossipTopic;
    private final SynchronousQueue<Message> messageRendezvous;

    public GossipListener(ConnectionFactor gossipConnectionFactor, Topic gossipTopic, SynchronousQueue<Message> messageRendezvous) throws JMSException {
        this.gossipConnectionFactor = gossipConnectionFactor;
        this.gossipTopic = gossipTopic;
        this.messageRendezvous = messageRendezvous;
        this.gossipConnectionFactor.createConsumer(this);
    }

    @Override
    public Destination getDestination() {
        return this.gossipTopic;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    public void close() throws JMSException {
        if (this.closed.compareAndSet(false, true)) {
            this.gossipConnectionFactor.stop();
            this.gossipConnectionFactor.close();
        }
    }

    public synchronized void onMessage(final Message message) {
        try {
            long timeInQueue = System.currentTimeMillis() - message.getJMSTimestamp();
            LoggerManager.getLogger(QueueOperator.class).debug("gossip message received(%s)...", new Object[]{message.getJMSMessageID()});
            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(timeInQueue >= 0L ? timeInQueue : 0L), (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("destination", MetricDestination.GOSSIP_TOPIC.getDisplay())});
            InstrumentationManager.execute((Instrument)new ChronometerInstrument(TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.ACQUIRE_WORKER.getDisplay())}){

                public void withChronometer() throws InterruptedException {
                    boolean success;
                    do {
                        success = GossipListener.this.messageRendezvous.offer(message, 1L, TimeUnit.SECONDS);
                    } while (!GossipListener.this.closed.get() && !success);
                }
            });
        }
        catch (Exception exception) {
            LoggerManager.getLogger(GossipListener.class).error((Throwable)exception);
        }
    }
}

