/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Topic;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessagePolicy;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.ReconnectionPolicy;
import org.smallmind.quorum.transport.message.TransportManagedObjects;
import org.smallmind.quorum.transport.message.gossip.GossipListener;
import org.smallmind.quorum.transport.message.gossip.GossipTarget;
import org.smallmind.quorum.transport.message.gossip.GossipWorker;

public class GossipReceiver {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final GossipListener[] gossipListeners;
    private final GossipWorker[] gossipWorkers;
    private final ConnectionFactor[] gossipConnectionFactors;

    public GossipReceiver(TransportManagedObjects gossipManagedObjects, MessagePolicy messagePolicy, ReconnectionPolicy reconnectionPolicy, MessageStrategy messageStrategy, int clusterSize, int concurrencyLimit, GossipTarget ... gossipTargets) throws IOException, JMSException, TransportException {
        SynchronousQueue<Message> messageRendezvous = new SynchronousQueue<Message>(true);
        HashMap<String, GossipTarget> targetMap = new HashMap<String, GossipTarget>();
        GossipTarget[] gossipTargetArray = gossipTargets;
        int n = gossipTargets.length;
        int n2 = 0;
        while (n2 < n) {
            GossipTarget gossipTarget = gossipTargetArray[n2];
            targetMap.put(gossipTarget.getServiceInterface().getName(), gossipTarget);
            ++n2;
        }
        this.gossipListeners = new GossipListener[clusterSize];
        int index = 0;
        while (index < this.gossipListeners.length) {
            this.gossipListeners[index] = new GossipListener(new ConnectionFactor(gossipManagedObjects, messagePolicy, reconnectionPolicy), (Topic)gossipManagedObjects.getDestination(), messageRendezvous);
            ++index;
        }
        this.gossipConnectionFactors = new ConnectionFactor[clusterSize];
        index = 0;
        while (index < this.gossipConnectionFactors.length) {
            this.gossipConnectionFactors[index] = new ConnectionFactor(gossipManagedObjects, messagePolicy, reconnectionPolicy);
            ++index;
        }
        this.gossipWorkers = new GossipWorker[concurrencyLimit];
        index = 0;
        while (index < this.gossipWorkers.length) {
            this.gossipWorkers[index] = new GossipWorker(messageStrategy, targetMap, messageRendezvous);
            new Thread(this.gossipWorkers[index]).start();
            ++index;
        }
    }

    public void close() throws JMSException, InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            Object gossipConnectionFactor;
            Object[] objectArray = this.gossipListeners;
            int n = this.gossipListeners.length;
            int n2 = 0;
            while (n2 < n) {
                GossipListener gossipListener = objectArray[n2];
                gossipListener.close();
                ++n2;
            }
            objectArray = this.gossipConnectionFactors;
            n = this.gossipConnectionFactors.length;
            n2 = 0;
            while (n2 < n) {
                gossipConnectionFactor = objectArray[n2];
                ((ConnectionFactor)gossipConnectionFactor).stop();
                ++n2;
            }
            objectArray = this.gossipWorkers;
            n = this.gossipWorkers.length;
            n2 = 0;
            while (n2 < n) {
                Object gossipWorker = objectArray[n2];
                ((GossipWorker)gossipWorker).stop();
                ++n2;
            }
            objectArray = this.gossipConnectionFactors;
            n = this.gossipConnectionFactors.length;
            n2 = 0;
            while (n2 < n) {
                gossipConnectionFactor = objectArray[n2];
                ((ConnectionFactor)gossipConnectionFactor).close();
                ++n2;
            }
        }
    }
}

