/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Message;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.gossip.GossipTarget;
import org.smallmind.scribe.pen.LoggerManager;

public class GossipWorker
implements Runnable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final MessageStrategy messageStrategy;
    private final Map<String, GossipTarget> targetMap;
    private final SynchronousQueue<Message> messageRendezvous;

    public GossipWorker(MessageStrategy messageStrategy, Map<String, GossipTarget> targetMap, SynchronousQueue<Message> messageRendezvous) {
        this.messageStrategy = messageStrategy;
        this.targetMap = targetMap;
        this.messageRendezvous = messageRendezvous;
    }

    public void stop() throws InterruptedException {
        this.stopped.set(true);
        this.exitLatch.await();
    }

    @Override
    public void run() {
        long idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
        try {
            try {
                while (!this.stopped.get()) {
                    Message gossipMessage = this.messageRendezvous.poll(1L, TimeUnit.SECONDS);
                    if (gossipMessage == null) continue;
                    InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(Clocks.EPOCH.getClock().getTimeNanoseconds() - idleStart), (TimeUnit)TimeUnit.NANOSECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("event", MetricEvent.WORKER_IDLE.getDisplay())});
                    try {
                        String serviceSelector = gossipMessage.getStringProperty(MessageProperty.SERVICE.getKey());
                        if (serviceSelector == null) {
                            throw new TransportException("Missing message property(%s)", MessageProperty.SERVICE.getKey());
                        }
                        GossipTarget gossipTarget = this.targetMap.get(serviceSelector);
                        if (gossipTarget == null) {
                            throw new TransportException("Unknown service selector(%s)", serviceSelector);
                        }
                        gossipTarget.handleMessage(this.messageStrategy, gossipMessage);
                    }
                    catch (Throwable throwable) {
                        LoggerManager.getLogger(GossipWorker.class).error(throwable);
                    }
                    idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(GossipWorker.class).error((Throwable)exception);
                this.exitLatch.countDown();
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

