/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import javax.jms.Message;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MethodInvoker;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.gossip.GossipTarget;

public class InvocationGossipTarget
implements GossipTarget {
    private MethodInvoker methodInvoker;
    private Class serviceInterface;

    public InvocationGossipTarget(Object targetObject, Class serviceInterface) throws NoSuchMethodException {
        this.serviceInterface = serviceInterface;
        this.methodInvoker = new MethodInvoker(targetObject, new Class[]{this.serviceInterface});
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public void handleMessage(MessageStrategy messageStrategy, Message message) throws Exception {
        final InvocationSignal invocationSignal = (InvocationSignal)messageStrategy.unwrapFromMessage(message);
        InstrumentationManager.execute((Instrument)new ChronometerInstrument(TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.INVOCATION.getDisplay()), new MetricProperty("service", this.serviceInterface.getSimpleName()), new MetricProperty("method", invocationSignal.getFauxMethod().getName())}){

            public void withChronometer() throws Exception {
                InvocationGossipTarget.this.methodInvoker.remoteInvocation(invocationSignal);
            }
        });
    }
}

