/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;

public abstract class PoolConfig<P extends PoolConfig> {
    private final AtomicLong acquireWaitTimeMillis = new AtomicLong(0L);
    private final AtomicInteger maxPoolSize = new AtomicInteger(10);

    public PoolConfig() {
    }

    public PoolConfig(PoolConfig<?> poolConfig) {
        this.setAcquireWaitTimeMillis(poolConfig.getAcquireWaitTimeMillis());
        this.setMaxPoolSize(poolConfig.getMaxPoolSize());
    }

    public abstract Class<P> getConfigurationClass();

    public int getMaxPoolSize() {
        return this.maxPoolSize.get();
    }

    public P setMaxPoolSize(int maxPoolSize) {
        if (maxPoolSize < 0) {
            throw new IllegalArgumentException("Maximum pool size must be >= 0");
        }
        this.maxPoolSize.set(maxPoolSize);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }

    public long getAcquireWaitTimeMillis() {
        return this.acquireWaitTimeMillis.get();
    }

    public P setAcquireWaitTimeMillis(long acquireWaitTimeMillis) {
        if (acquireWaitTimeMillis < 0L) {
            throw new IllegalArgumentException("Acquire wait time must be >= 0");
        }
        this.acquireWaitTimeMillis.set(acquireWaitTimeMillis);
        return (P)((PoolConfig)this.getConfigurationClass().cast(this));
    }
}

