/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.quorum.transport.TransportTimeoutException;
import org.smallmind.quorum.transport.message.MessagePlus;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.TransmissionCallback;

public class AsynchronousTransmissionCallback
implements TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<MessagePlus> messagePlusRef = new AtomicReference();
    private final MessageStrategy messageStrategy;
    private final long timeoutSeconds;

    public AsynchronousTransmissionCallback(MessageStrategy messageStrategy, long timeoutSeconds) {
        this.messageStrategy = messageStrategy;
        this.timeoutSeconds = timeoutSeconds;
    }

    public void destroy() {
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult() throws Exception {
        this.resultLatch.await();
        MessagePlus messagePlus = this.messagePlusRef.get();
        if (messagePlus == null) {
            throw new TransportTimeoutException("The timeout(%d) seconds was exceeded while waiting for a response", this.timeoutSeconds);
        }
        InstrumentationManager.appendMetricContext((MetricContext)messagePlus.getMetricContext());
        if (messagePlus.getMessage().getBooleanProperty(MessageProperty.EXCEPTION.getKey())) {
            throw (Exception)this.messageStrategy.unwrapFromMessage(messagePlus.getMessage());
        }
        return this.messageStrategy.unwrapFromMessage(messagePlus.getMessage());
    }

    public void setResponseMessage(MessagePlus messagePlus) {
        this.messagePlusRef.set(messagePlus);
        this.resultLatch.countDown();
    }
}

