/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import javax.jms.Message;
import javax.jms.Session;
import org.smallmind.instrument.ChronometerInstrumentAndReturn;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.MethodInvoker;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;
import org.smallmind.scribe.pen.Level;
import org.smallmind.scribe.pen.LoggerManager;

public class InvocationMessageTarget
implements MessageTarget {
    private MethodInvoker methodInvoker;
    private Class serviceInterface;
    private Level logLevel = Level.DEBUG;

    public InvocationMessageTarget(Object targetObject, Class serviceInterface) throws NoSuchMethodException {
        this.serviceInterface = serviceInterface;
        this.methodInvoker = new MethodInvoker(targetObject, new Class[]{this.serviceInterface});
    }

    public InvocationMessageTarget setLogLevel(Level logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public Class getServiceInterface() {
        return this.serviceInterface;
    }

    @Override
    public Message handleMessage(final Session session, final MessageStrategy messageStrategy, Message message) throws Exception {
        Serializable result;
        InvocationSignal invocationSignal = (InvocationSignal)messageStrategy.unwrapFromMessage(message);
        long startTime = System.currentTimeMillis();
        try {
            result = (Serializable)this.methodInvoker.remoteInvocation(invocationSignal);
            long totalTime = System.currentTimeMillis() - startTime;
            InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)totalTime, (TimeUnit)TimeUnit.MILLISECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("event", MetricEvent.INVOCATION.getDisplay()), new MetricProperty("service", this.serviceInterface.getSimpleName()), new MetricProperty("method", invocationSignal.getFauxMethod().getName())});
            LoggerManager.getLogger(InvocationMessageTarget.class).log(this.logLevel, "%s.%s() %d ms", new Object[]{this.serviceInterface.getSimpleName(), invocationSignal.getFauxMethod().getName(), totalTime});
        }
        catch (Exception exception) {
            LoggerManager.getLogger(InvocationMessageTarget.class).log(this.logLevel, "%s.%s() %d ms - %s", new Object[]{this.serviceInterface.getSimpleName(), invocationSignal.getFauxMethod().getName(), System.currentTimeMillis() - startTime, exception.getMessage()});
            throw exception;
        }
        return (Message)InstrumentationManager.execute((InstrumentAndReturn)new ChronometerInstrumentAndReturn<Message>((MetricConfigurationProvider)TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("event", MetricEvent.CONSTRUCT_MESSAGE.getDisplay())}){

            public Message withChronometer() throws Exception {
                return messageStrategy.wrapInMessage(session, result);
            }
        });
    }
}

