/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Queue;
import javax.jms.Session;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class QueueOperator
implements SessionEmployer {
    private final ConnectionFactor connectionFactor;
    private final Queue requestQueue;

    public QueueOperator(ConnectionFactor connectionFactor, Queue queue) {
        this.connectionFactor = connectionFactor;
        this.requestQueue = queue;
    }

    @Override
    public Destination getDestination() {
        return this.requestQueue;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    public Session getQueueSession() throws JMSException {
        return this.connectionFactor.getSession(this);
    }

    public void send(Message message) throws JMSException {
        this.connectionFactor.getProducer(this).send(message);
        LoggerManager.getLogger(QueueOperator.class).debug("queue message sent(%s)...", new Object[]{message.getJMSMessageID()});
    }
}

