/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.Message;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricEvent;
import org.smallmind.quorum.transport.message.MessagePlus;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.MessageTarget;
import org.smallmind.quorum.transport.message.TopicOperator;
import org.smallmind.scribe.pen.LoggerManager;

public class ReceptionWorker
implements Runnable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final MessageStrategy messageStrategy;
    private final Map<String, MessageTarget> targetMap;
    private final TransferQueue<MessagePlus> messageRendezvous;
    private final ConcurrentLinkedQueue<TopicOperator> operatorQueue;

    public ReceptionWorker(MessageStrategy messageStrategy, Map<String, MessageTarget> targetMap, TransferQueue<MessagePlus> messageRendezvous, ConcurrentLinkedQueue<TopicOperator> operatorQueue) {
        this.messageStrategy = messageStrategy;
        this.targetMap = targetMap;
        this.messageRendezvous = messageRendezvous;
        this.operatorQueue = operatorQueue;
    }

    public void stop() throws InterruptedException {
        this.stopped.set(true);
        this.exitLatch.await();
    }

    @Override
    public void run() {
        long idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
        try {
            try {
                while (!this.stopped.get()) {
                    block17: {
                        MessagePlus messagePlus = (MessagePlus)this.messageRendezvous.poll(1L, TimeUnit.SECONDS);
                        if (messagePlus == null) continue;
                        InstrumentationManager.setMetricContext((MetricContext)messagePlus.getMetricContext());
                        InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(Clocks.EPOCH.getClock().getTimeNanoseconds() - idleStart), (TimeUnit)TimeUnit.NANOSECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("event", MetricEvent.WORKER_IDLE.getDisplay())});
                        TopicOperator topicOperator = this.operatorQueue.poll();
                        if (topicOperator == null) {
                            throw new TransportException("Unable to take a TopicOperator, which should never happen - please contact your system administrator", new Object[0]);
                        }
                        try {
                            try {
                                Message responseMessage;
                                String transmissionInstance = messagePlus.getMessage().getStringProperty(MessageProperty.INSTANCE.getKey());
                                if (transmissionInstance == null) {
                                    throw new TransportException("Missing message property(%s)", MessageProperty.INSTANCE.getKey());
                                }
                                try {
                                    String serviceSelector = messagePlus.getMessage().getStringProperty(MessageProperty.SERVICE.getKey());
                                    if (serviceSelector == null) {
                                        throw new TransportException("Missing message property(%s)", MessageProperty.SERVICE.getKey());
                                    }
                                    MessageTarget messageTarget = this.targetMap.get(serviceSelector);
                                    if (messageTarget == null) {
                                        throw new TransportException("Unknown service selector(%s)", serviceSelector);
                                    }
                                    responseMessage = messageTarget.handleMessage(topicOperator.getTopicSession(), this.messageStrategy, messagePlus.getMessage());
                                }
                                catch (Exception exception) {
                                    responseMessage = this.messageStrategy.wrapInMessage(topicOperator.getTopicSession(), exception);
                                    responseMessage.setBooleanProperty(MessageProperty.EXCEPTION.getKey(), true);
                                }
                                responseMessage.setJMSCorrelationID(messagePlus.getMessage().getJMSMessageID());
                                responseMessage.setStringProperty(MessageProperty.INSTANCE.getKey(), transmissionInstance);
                                responseMessage.setLongProperty(MessageProperty.CLOCK.getKey(), System.currentTimeMillis());
                                topicOperator.publish(responseMessage);
                            }
                            catch (Throwable throwable) {
                                LoggerManager.getLogger(ReceptionWorker.class).error(throwable);
                                this.operatorQueue.add(topicOperator);
                                InstrumentationManager.publishMetricContext();
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            this.operatorQueue.add(topicOperator);
                            InstrumentationManager.publishMetricContext();
                            throw throwable;
                        }
                        this.operatorQueue.add(topicOperator);
                        InstrumentationManager.publishMetricContext();
                    }
                    idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ReceptionWorker.class).error((Throwable)exception);
                this.exitLatch.countDown();
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

