/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.jndi;

import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.QueueConnectionFactory;
import javax.naming.Context;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.TransportManagedObjects;
import org.smallmind.quorum.transport.message.jndi.MessageConnectionDetails;

public class JNDITransportManagedObjects
implements TransportManagedObjects {
    private MessageConnectionDetails messageConnectionDetails;

    public JNDITransportManagedObjects(MessageConnectionDetails messageConnectionDetails) {
        this.messageConnectionDetails = messageConnectionDetails;
    }

    @Override
    public Connection createConnection() throws TransportException {
        try {
            QueueConnectionFactory queueConnectionFactory;
            try (Context javaEnvironment = this.messageConnectionDetails.getContextPool().getComponent();){
                queueConnectionFactory = (QueueConnectionFactory)javaEnvironment.lookup(this.messageConnectionDetails.getConnectionFactoryName());
            }
            return queueConnectionFactory.createQueueConnection(this.messageConnectionDetails.getUserName(), this.messageConnectionDetails.getPassword());
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
    }

    @Override
    public Destination getDestination() throws TransportException {
        try {
            Queue queue;
            try (Context javaEnvironment = this.messageConnectionDetails.getContextPool().getComponent();){
                queue = (Queue)javaEnvironment.lookup(this.messageConnectionDetails.getDestinationName());
            }
            return queue;
        }
        catch (Exception exception) {
            throw new TransportException(exception);
        }
    }
}

