/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.quorum.transport.TransportTimeoutException;
import org.smallmind.quorum.transport.message.MessagePlus;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.TransmissionCallback;

public class AsynchronousTransmissionCallback
implements TransmissionCallback {
    private final CountDownLatch resultLatch = new CountDownLatch(1);
    private final AtomicReference<Duration> timeoutDurationRef = new AtomicReference();
    private final AtomicReference<MessagePlus> messagePlusRef = new AtomicReference();
    private final MessageStrategy messageStrategy;

    public AsynchronousTransmissionCallback(MessageStrategy messageStrategy) {
        this.messageStrategy = messageStrategy;
    }

    public void destroy(Duration timeoutDuration) {
        this.timeoutDurationRef.set(timeoutDuration);
        this.resultLatch.countDown();
    }

    @Override
    public Object getResult() throws Exception {
        this.resultLatch.await();
        MessagePlus messagePlus = this.messagePlusRef.get();
        if (messagePlus == null) {
            Duration timeoutDuration = this.timeoutDurationRef.get();
            throw new TransportTimeoutException("The timeout(%s) milliseconds was exceeded while waiting for a response", timeoutDuration == null ? "unknown" : String.valueOf(timeoutDuration.toMilliseconds()));
        }
        InstrumentationManager.appendMetricContext((MetricContext)messagePlus.getMetricContext());
        if (messagePlus.getMessage().getBooleanProperty(MessageProperty.EXCEPTION.getKey())) {
            throw (Exception)this.messageStrategy.unwrapFromMessage(messagePlus.getMessage());
        }
        return this.messageStrategy.unwrapFromMessage(messagePlus.getMessage());
    }

    public void setResponseMessage(MessagePlus messagePlus) {
        this.messagePlusRef.set(messagePlus);
        this.resultLatch.countDown();
    }
}

