/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message;

import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import javax.jms.Topic;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.SessionEmployer;
import org.smallmind.scribe.pen.LoggerManager;

public class TopicOperator
implements SessionEmployer {
    private final ConnectionFactor connectionFactor;
    private final Topic topic;

    public TopicOperator(ConnectionFactor connectionFactor, Topic topic) {
        this.connectionFactor = connectionFactor;
        this.topic = topic;
    }

    @Override
    public Destination getDestination() {
        return this.topic;
    }

    @Override
    public String getMessageSelector() {
        return null;
    }

    public Session getTopicSession() throws JMSException {
        return this.connectionFactor.getSession(this);
    }

    public void publish(Message message) throws JMSException {
        this.connectionFactor.getProducer(this).send(message);
        LoggerManager.getLogger(TopicOperator.class).debug("topic message sent(%s)...", new Object[]{message.getJMSMessageID()});
    }
}

