/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.instrument.Clocks;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.instrument.context.MetricContext;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricInteraction;
import org.smallmind.quorum.transport.message.MessagePlus;
import org.smallmind.quorum.transport.message.MessageProperty;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.gossip.GossipTarget;
import org.smallmind.scribe.pen.LoggerManager;

public class GossipWorker
implements Runnable {
    private final AtomicBoolean stopped = new AtomicBoolean(false);
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final MessageStrategy messageStrategy;
    private final Map<String, GossipTarget> targetMap;
    private final TransferQueue<MessagePlus> messageRendezvous;

    public GossipWorker(MessageStrategy messageStrategy, Map<String, GossipTarget> targetMap, TransferQueue<MessagePlus> messageRendezvous) {
        this.messageStrategy = messageStrategy;
        this.targetMap = targetMap;
        this.messageRendezvous = messageRendezvous;
    }

    public void stop() throws InterruptedException {
        this.stopped.set(true);
        this.exitLatch.await();
    }

    @Override
    public void run() {
        long idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
        try {
            try {
                while (!this.stopped.get()) {
                    block13: {
                        MessagePlus messagePlus = (MessagePlus)this.messageRendezvous.poll(1L, TimeUnit.SECONDS);
                        if (messagePlus == null) continue;
                        InstrumentationManager.setMetricContext((MetricContext)messagePlus.getMetricContext());
                        InstrumentationManager.instrumentWithChronometer((MetricConfigurationProvider)TransportManager.getTransport(), (long)(Clocks.EPOCH.getClock().getTimeNanoseconds() - idleStart), (TimeUnit)TimeUnit.NANOSECONDS, (MetricProperty[])new MetricProperty[]{new MetricProperty("gossip", "true"), new MetricProperty("event", MetricInteraction.WORKER_IDLE.getDisplay())});
                        try {
                            try {
                                String serviceSelector = messagePlus.getMessage().getStringProperty(MessageProperty.SERVICE.getKey());
                                if (serviceSelector == null) {
                                    throw new TransportException("Missing message property(%s)", MessageProperty.SERVICE.getKey());
                                }
                                GossipTarget gossipTarget = this.targetMap.get(serviceSelector);
                                if (gossipTarget == null) {
                                    throw new TransportException("Unknown service selector(%s)", serviceSelector);
                                }
                                gossipTarget.handleMessage(this.messageStrategy, messagePlus.getMessage());
                            }
                            catch (Throwable throwable) {
                                LoggerManager.getLogger(GossipWorker.class).error(throwable);
                                InstrumentationManager.publishMetricContext();
                                break block13;
                            }
                        }
                        catch (Throwable throwable) {
                            InstrumentationManager.publishMetricContext();
                            throw throwable;
                        }
                        InstrumentationManager.publishMetricContext();
                    }
                    idleStart = Clocks.EPOCH.getClock().getTimeNanoseconds();
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(GossipWorker.class).error((Throwable)exception);
                this.exitLatch.countDown();
            }
        }
        finally {
            this.exitLatch.countDown();
        }
    }
}

