/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.config.MetricConfigurationProvider;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.PoolManager;
import org.smallmind.quorum.pool.complex.ComponentCreationException;
import org.smallmind.quorum.pool.complex.ComponentCreationWorker;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPin;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.ComponentValidationException;
import org.smallmind.quorum.pool.complex.DeconstructionQueue;
import org.smallmind.quorum.pool.instrument.MetricInteraction;
import org.smallmind.quorum.pool.instrument.MetricSize;
import org.smallmind.scribe.pen.LoggerManager;

public class ComponentPinManager<C> {
    private final ComponentPool<C> componentPool;
    private final HashMap<ComponentInstance<C>, ComponentPin<C>> backingMap = new HashMap();
    private final LinkedBlockingQueue<ComponentPin<C>> freeQueue = new LinkedBlockingQueue();
    private final ReentrantReadWriteLock backingLock = new ReentrantReadWriteLock();
    private final DeconstructionQueue deconstructionQueue = new DeconstructionQueue();
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.STOPPED);
    private final AtomicInteger size = new AtomicInteger(0);

    public ComponentPinManager(ComponentPool<C> componentPool) {
        this.componentPool = componentPool;
    }

    /*
     * Exception decompiling
     */
    public void startup() throws ComponentPoolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public ComponentPin<C> serve() throws ComponentPoolException {
        if (!State.STARTED.equals((Object)this.stateRef.get())) {
            throw new ComponentPoolException("%s is not in the 'started' state", ComponentPool.class.getSimpleName());
        }
        ComponentPin<C> componentPin = this.freeQueue.poll();
        if (componentPin != null) {
            if (this.componentPool.getComplexPoolConfig().isTestOnAcquire() && !componentPin.getComponentInstance().validate()) {
                throw new ComponentValidationException("A free element was acquired, but failed to validate", new Object[0]);
            }
            this.trackSize();
            return componentPin;
        }
        componentPin = this.addComponentPin(true);
        if (componentPin != null) {
            this.trackSize();
            return componentPin;
        }
        try {
            if (this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis() > 0L && (componentPin = this.freeQueue.poll(this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis(), TimeUnit.MILLISECONDS)) != null) {
                if (this.componentPool.getComplexPoolConfig().isTestOnAcquire() && !componentPin.getComponentInstance().validate()) {
                    throw new ComponentValidationException("A free element was acquired, but failed to validate", new Object[0]);
                }
                this.trackSize();
                return componentPin;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ComponentPoolException(interruptedException);
        }
        this.trackTimeout();
        throw new ComponentPoolException("Exceeded the maximum acquire wait time(%d)", this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis());
    }

    private ComponentPin<C> addComponentPin(boolean forced) throws ComponentCreationException, ComponentValidationException {
        if (State.STARTED.equals((Object)this.stateRef.get())) {
            int minPoolSize = this.componentPool.getComplexPoolConfig().getMinPoolSize();
            int maxPoolSize = this.componentPool.getComplexPoolConfig().getMaxPoolSize();
            int currentSize = this.size.get();
            if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                this.backingLock.writeLock().lock();
                try {
                    currentSize = this.size.get();
                    if (!(!forced && currentSize <= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                        ComponentInstance<C> componentInstance = this.manufactureComponentInstance();
                        ComponentPin<C> componentPin = new ComponentPin<C>(this.componentPool, this.deconstructionQueue, componentInstance);
                        this.backingMap.put(componentInstance, componentPin);
                        this.size.incrementAndGet();
                        ComponentPin<C> componentPin2 = componentPin;
                        return componentPin2;
                    }
                }
                finally {
                    this.backingLock.writeLock().unlock();
                }
            }
        }
        return null;
    }

    private ComponentInstance<C> manufactureComponentInstance() throws ComponentCreationException, ComponentValidationException {
        ComponentInstance<C> componentInstance;
        try {
            if (this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis() > 0L) {
                ComponentCreationWorker<C> creationWorker = new ComponentCreationWorker<C>(this.componentPool);
                Thread workerThread = new Thread(creationWorker);
                workerThread.setDaemon(true);
                workerThread.start();
                workerThread.join(this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis());
                if (creationWorker.abort()) {
                    throw new ComponentCreationException("Exceeded element timeout(%d) waiting on element creation (pool size = %d, free size = %d)", this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis(), this.getPoolSize(), this.getFreeSize());
                }
                componentInstance = creationWorker.getComponentInstance();
            } else {
                componentInstance = this.componentPool.getComponentInstanceFactory().createInstance(this.componentPool);
            }
        }
        catch (ComponentCreationException componentCreationException) {
            throw componentCreationException;
        }
        catch (Exception exception) {
            throw new ComponentCreationException(exception);
        }
        if (this.componentPool.getComplexPoolConfig().isTestOnCreate() && !componentInstance.validate()) {
            throw new ComponentValidationException("A new element was required, but failed to validate", new Object[0]);
        }
        return componentInstance;
    }

    public void remove(ComponentPin<C> componentPin, boolean withPrejudice) {
        if (this.freeQueue.remove(componentPin) || withPrejudice) {
            this.terminate(componentPin.getComponentInstance());
            this.trackSize();
        }
    }

    public void process(ComponentInstance<C> componentInstance) {
        ComponentPin<C> componentPin;
        this.backingLock.readLock().lock();
        try {
            componentPin = this.backingMap.get(componentInstance);
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        if (componentPin != null) {
            componentPin.free();
            if (componentPin.isTerminated()) {
                this.terminate(componentPin.getComponentInstance());
            } else if (State.STARTED.equals((Object)this.stateRef.get())) {
                try {
                    this.freeQueue.put(componentPin);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)interruptedException);
                }
            }
            this.trackSize();
        }
    }

    public void terminate(ComponentInstance<C> componentInstance) {
        ComponentPin<C> componentPin;
        this.backingLock.writeLock().lock();
        try {
            componentPin = this.backingMap.remove(componentInstance);
        }
        finally {
            this.backingLock.writeLock().unlock();
        }
        if (componentPin != null) {
            this.size.decrementAndGet();
            componentPin.fizzle();
            try {
                componentPin.getComponentInstance().close();
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)exception);
            }
            try {
                ComponentPin<C> replacementComponentPin = this.addComponentPin(false);
                if (replacementComponentPin != null) {
                    this.freeQueue.put(replacementComponentPin);
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)exception);
            }
            this.trackSize();
        }
    }

    /*
     * Exception decompiling
     */
    public void shutdown() throws ComponentPoolException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public int getPoolSize() {
        return this.size.get();
    }

    public int getFreeSize() {
        return this.freeQueue.size();
    }

    public int getProcessingSize() {
        return this.getPoolSize() - this.getFreeSize();
    }

    private void trackSize() {
        int freeSize = this.freeQueue.size();
        InstrumentationManager.instrumentWithSpeedometer((MetricConfigurationProvider)PoolManager.getPool(), (long)freeSize, (MetricProperty[])new MetricProperty[]{new MetricProperty("pool", this.componentPool.getPoolName()), new MetricProperty("size", MetricSize.FREE.getDisplay())});
        InstrumentationManager.instrumentWithSpeedometer((MetricConfigurationProvider)PoolManager.getPool(), (long)(this.getPoolSize() - freeSize), (MetricProperty[])new MetricProperty[]{new MetricProperty("pool", this.componentPool.getPoolName()), new MetricProperty("size", MetricSize.PROCESSING.getDisplay())});
    }

    private void trackTimeout() {
        InstrumentationManager.instrumentWithMeter((MetricConfigurationProvider)PoolManager.getPool(), (MetricProperty[])new MetricProperty[]{new MetricProperty("pool", this.componentPool.getPoolName()), new MetricProperty("pool", this.componentPool.getPoolName()), new MetricProperty("event", MetricInteraction.TIMEOUT.getDisplay())});
    }

    public StackTrace[] getExistentialStackTraces() {
        LinkedList<StackTrace> stackTraceList = new LinkedList<StackTrace>();
        this.backingLock.readLock().lock();
        try {
            for (ComponentPin<C> componentPin : this.backingMap.values()) {
                if (this.freeQueue.contains(componentPin)) continue;
                stackTraceList.add(new StackTrace(componentPin.getExistentialStackTrace()));
            }
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        StackTrace[] stackTraces = new StackTrace[stackTraceList.size()];
        stackTraceList.toArray(stackTraces);
        return stackTraces;
    }

    private static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

