/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.io.IOException;
import java.util.HashMap;
import java.util.concurrent.LinkedTransferQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.jms.JMSException;
import javax.jms.Topic;
import org.smallmind.quorum.transport.TransportException;
import org.smallmind.quorum.transport.message.ConnectionFactor;
import org.smallmind.quorum.transport.message.MessagePlus;
import org.smallmind.quorum.transport.message.MessagePolicy;
import org.smallmind.quorum.transport.message.MessageStrategy;
import org.smallmind.quorum.transport.message.ReconnectionPolicy;
import org.smallmind.quorum.transport.message.TransportManagedObjects;
import org.smallmind.quorum.transport.message.gossip.GossipListener;
import org.smallmind.quorum.transport.message.gossip.GossipTarget;
import org.smallmind.quorum.transport.message.gossip.GossipWorker;

public class GossipReceiver {
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final GossipListener gossipListener;
    private final GossipWorker[] gossipWorkers;

    public GossipReceiver(TransportManagedObjects gossipManagedObjects, MessagePolicy messagePolicy, ReconnectionPolicy reconnectionPolicy, MessageStrategy messageStrategy, int concurrencyLimit, GossipTarget ... gossipTargets) throws IOException, JMSException, TransportException {
        LinkedTransferQueue<MessagePlus> messageRendezvous = new LinkedTransferQueue<MessagePlus>();
        HashMap<String, GossipTarget> targetMap = new HashMap<String, GossipTarget>();
        GossipTarget[] gossipTargetArray = gossipTargets;
        int n = gossipTargets.length;
        int n2 = 0;
        while (n2 < n) {
            GossipTarget gossipTarget = gossipTargetArray[n2];
            targetMap.put(gossipTarget.getServiceInterface().getName(), gossipTarget);
            ++n2;
        }
        this.gossipListener = new GossipListener(new ConnectionFactor(gossipManagedObjects, messagePolicy, reconnectionPolicy), (Topic)gossipManagedObjects.getDestination(), messageRendezvous);
        this.gossipWorkers = new GossipWorker[concurrencyLimit];
        int index = 0;
        while (index < this.gossipWorkers.length) {
            this.gossipWorkers[index] = new GossipWorker(messageStrategy, targetMap, messageRendezvous);
            new Thread(this.gossipWorkers[index]).start();
            ++index;
        }
    }

    public void close() throws JMSException, InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            this.gossipListener.close();
            GossipWorker[] gossipWorkerArray = this.gossipWorkers;
            int n = this.gossipWorkers.length;
            int n2 = 0;
            while (n2 < n) {
                GossipWorker gossipWorker = gossipWorkerArray[n2];
                gossipWorker.stop();
                ++n2;
            }
        }
    }
}

