/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.multicast.event;

import java.nio.ByteBuffer;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.quorum.multicast.event.MessageStatus;
import org.smallmind.quorum.multicast.event.MessageType;

public abstract class EventMessage {
    public static final int MESSAGE_HEADER_SIZE = SnowflakeId.byteSize() + 16;
    private ByteBuffer translationBuffer;

    public EventMessage(byte[] messageId, MessageType messageType, int messageLength, int extraSize) {
        byte[] messageArray = new byte[messageId.length + 12 + extraSize];
        this.translationBuffer = ByteBuffer.wrap(messageArray);
        this.translationBuffer.putInt(MessageStatus.MULTICAST.ordinal());
        this.translationBuffer.put(messageId);
        this.translationBuffer.putInt(messageType.ordinal());
        this.translationBuffer.putInt(messageLength);
    }

    public void put(byte[] b) {
        this.translationBuffer.put(b);
    }

    public void putInt(int i) {
        this.translationBuffer.putInt(i);
    }

    public void putLong(long l) {
        this.translationBuffer.putLong(l);
    }

    public ByteBuffer getByteBuffer() {
        return this.translationBuffer;
    }
}

