/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.multicast.event;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.TreeMap;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.nutsnbolts.util.SelfDestructive;

public class EventMessageMold
implements SelfDestructive {
    private TreeMap<Integer, byte[]> messageSegmentMap = new TreeMap();
    private int messageLength = 0;
    private int totalBytes = 0;

    public void destroy(Duration timeoutDuration) {
    }

    public void setMessageLength(int messageLength) {
        this.messageLength = messageLength;
    }

    public void addData(int messageIndex, byte[] messageSegment) {
        this.messageSegmentMap.put(messageIndex, messageSegment);
        this.totalBytes += messageSegment.length;
    }

    public boolean isComplete() {
        return this.messageLength != 0 && this.totalBytes >= this.messageLength;
    }

    public Object unmoldMessageBody() throws IOException, ClassNotFoundException {
        if (this.totalBytes == 0) {
            return null;
        }
        ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream(this.totalBytes);
        Iterator<Integer> segmentKeyIter = this.messageSegmentMap.keySet().iterator();
        while (segmentKeyIter.hasNext()) {
            byteOutputStream.write(this.messageSegmentMap.get(segmentKeyIter.next()));
        }
        byteOutputStream.close();
        ObjectInputStream objectInputStream = new ObjectInputStream(new ByteArrayInputStream(byteOutputStream.toByteArray()));
        Object unmoldedObject = objectInputStream.readObject();
        objectInputStream.close();
        return unmoldedObject;
    }
}

