/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.multicast.event;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.nutsnbolts.time.Duration;
import org.smallmind.nutsnbolts.util.SelfDestructiveMap;
import org.smallmind.nutsnbolts.util.SnowflakeId;
import org.smallmind.quorum.multicast.EventMessageException;
import org.smallmind.quorum.multicast.event.EventMessage;
import org.smallmind.quorum.multicast.event.EventMessageBody;
import org.smallmind.quorum.multicast.event.EventMessageHeader;
import org.smallmind.quorum.multicast.event.EventMessageKey;
import org.smallmind.quorum.multicast.event.EventMessageMold;
import org.smallmind.quorum.multicast.event.MessageType;
import org.smallmind.quorum.multicast.event.MulticastEvent;
import org.smallmind.quorum.multicast.event.MulticastEventHandler;
import org.smallmind.scribe.pen.Logger;

public class EventTransmitter
implements Runnable {
    private static final int SO_TIMEOUT = 1000;
    private static final int TTL = 3;
    private static final byte[] EMPTY_ID = new byte[SnowflakeId.byteSize()];
    private Logger logger;
    private CountDownLatch exitLatch;
    private AtomicBoolean finished = new AtomicBoolean(false);
    private SelfDestructiveMap<EventMessageKey, EventMessageMold> messageCache;
    private MulticastEventHandler eventHandler;
    private MulticastSocket multicastSocket;
    private InetAddress multicastInetAddr;
    private int multicastPort;
    private int messageSegmentSize;
    private int messageBufferSize;
    private static /* synthetic */ int[] $SWITCH_TABLE$org$smallmind$quorum$multicast$event$MessageType;

    static {
        Arrays.fill(EMPTY_ID, (byte)0);
    }

    public EventTransmitter(MulticastEventHandler eventHandler, Logger logger, InetAddress multicastInetAddr, int multicastPort, int messageSegmentSize) throws Exception {
        this.eventHandler = eventHandler;
        this.logger = logger;
        this.multicastInetAddr = multicastInetAddr;
        this.multicastPort = multicastPort;
        this.messageSegmentSize = messageSegmentSize;
        this.messageBufferSize = messageSegmentSize + EventMessage.MESSAGE_HEADER_SIZE;
        this.messageCache = new SelfDestructiveMap(new Duration(60L, TimeUnit.SECONDS), new Duration(3L, TimeUnit.SECONDS));
        this.multicastSocket = new MulticastSocket(multicastPort);
        this.multicastSocket.setReuseAddress(true);
        this.multicastSocket.setSoTimeout(1000);
        this.multicastSocket.setTimeToLive(3);
        this.multicastSocket.joinGroup(multicastInetAddr);
        this.exitLatch = new CountDownLatch(1);
        Thread receiverThread = new Thread(this);
        receiverThread.setDaemon(true);
        receiverThread.start();
    }

    public synchronized void fireEvent(MulticastEvent multicastEvent) throws EventMessageException {
        try {
            byte[] bodyBuffer = this.objectToByteArray(multicastEvent);
            byte[] messageId = multicastEvent != null ? SnowflakeId.newInstance().asByteArray() : EMPTY_ID;
            EventMessageHeader messageHeader = new EventMessageHeader(messageId, bodyBuffer.length);
            this.sendDatagram(messageHeader.getByteBuffer());
            this.sendBody(messageId, bodyBuffer);
        }
        catch (Exception e) {
            throw new EventMessageException(e);
        }
    }

    private byte[] objectToByteArray(Object body) throws IOException {
        byte[] bodyBuffer;
        if (body != null) {
            ByteArrayOutputStream byteOutputStream = new ByteArrayOutputStream();
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteOutputStream);
            objectOutputStream.writeObject(body);
            objectOutputStream.close();
            bodyBuffer = byteOutputStream.toByteArray();
        } else {
            bodyBuffer = new byte[]{};
        }
        return bodyBuffer;
    }

    private void sendBody(byte[] messageId, byte[] bodyBuffer) throws IOException {
        int bufferPos = 0;
        int messageIndex = 0;
        while (bufferPos < bodyBuffer.length) {
            int bytesToSend = Math.min(this.messageSegmentSize, bodyBuffer.length - bufferPos);
            byte[] bodySegment = new byte[bytesToSend];
            System.arraycopy(bodyBuffer, bufferPos, bodySegment, 0, bytesToSend);
            EventMessageBody messageBody = new EventMessageBody(messageId, messageIndex++, bodySegment);
            this.sendDatagram(messageBody.getByteBuffer());
            bufferPos += bytesToSend;
        }
    }

    private void sendDatagram(ByteBuffer dataBuffer) throws IOException {
        dataBuffer.flip();
        this.multicastSocket.send(new DatagramPacket(dataBuffer.array(), dataBuffer.position(), dataBuffer.limit() - dataBuffer.position(), this.multicastInetAddr, this.multicastPort));
    }

    public void logError(Throwable throwable) {
        this.logger.error(throwable);
    }

    public synchronized void finish() {
        if (this.finished.compareAndSet(false, true)) {
            try {
                this.exitLatch.await();
            }
            catch (InterruptedException interruptedException) {
                this.logError(interruptedException);
            }
            try {
                this.multicastSocket.leaveGroup(this.multicastInetAddr);
                this.multicastSocket.close();
            }
            catch (IOException ioException) {
                this.logError(ioException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [11[UNCONDITIONALDOLOOP]], but top level block is 0[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void finalize() {
        this.finish();
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$smallmind$quorum$multicast$event$MessageType() {
        if ($SWITCH_TABLE$org$smallmind$quorum$multicast$event$MessageType != null) {
            return $SWITCH_TABLE$org$smallmind$quorum$multicast$event$MessageType;
        }
        int[] nArray = new int[MessageType.values().length];
        try {
            nArray[MessageType.DATA.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[MessageType.HEADER.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$smallmind$quorum$multicast$event$MessageType = nArray;
        return nArray;
    }
}

