/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.transport.message.gossip;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import org.smallmind.instrument.ChronometerInstrument;
import org.smallmind.instrument.Instrument;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.nutsnbolts.context.ContextFactory;
import org.smallmind.quorum.transport.FauxMethod;
import org.smallmind.quorum.transport.InvocationSignal;
import org.smallmind.quorum.transport.TransportManager;
import org.smallmind.quorum.transport.instrument.MetricInteraction;
import org.smallmind.quorum.transport.message.gossip.GossipTransmitter;

public class GossipInvocationHandler
implements InvocationHandler {
    private GossipTransmitter gossipTransmitter;
    private Class serviceInterface;

    public GossipInvocationHandler(GossipTransmitter gossipTransmitter, Class serviceInterface) {
        this.gossipTransmitter = gossipTransmitter;
        this.serviceInterface = serviceInterface;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        InstrumentationManager.execute((Instrument)new ChronometerInstrument(TransportManager.getTransport(), new MetricProperty[]{new MetricProperty("gossip", "true"), new MetricProperty("event", MetricInteraction.INVOCATION.getDisplay()), new MetricProperty("service", this.serviceInterface.getSimpleName()), new MetricProperty("method", method.getName())}){

            public void withChronometer() throws Exception {
                GossipInvocationHandler.this.gossipTransmitter.sendMessage(new InvocationSignal(ContextFactory.getContextsOn((Method)method), new FauxMethod(method), args), GossipInvocationHandler.this.serviceInterface.getName());
            }
        });
        return null;
    }
}

