/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.smallmind.nutsnbolts.util.AlphaNumericComparator;
import org.smallmind.quorum.namespace.java.backingStore.NameTranslator;

public class JavaName
implements Name {
    private static final AlphaNumericComparator<String> alphaSort = new AlphaNumericComparator();
    private NameTranslator nameTranslator;
    private ArrayList<String> nameList;

    public JavaName(JavaName name) {
        this(name.getNameTranslator(), name.getNameList());
    }

    public JavaName(NameTranslator nameTranslator) {
        this(nameTranslator, new ArrayList<String>());
    }

    private JavaName(NameTranslator nameTranslator, List<String> externalList) {
        this.nameTranslator = nameTranslator;
        this.nameList = new ArrayList<String>(externalList);
    }

    protected NameTranslator getNameTranslator() {
        return this.nameTranslator;
    }

    protected ArrayList<String> getNameList() {
        return this.nameList;
    }

    @Override
    public int compareTo(Object obj) {
        if (!(obj instanceof JavaName)) {
            throw new ClassCastException("Must be an instance of (" + this.getClass().getName() + ")");
        }
        if (this.nameList.size() < ((JavaName)obj).size()) {
            return -1;
        }
        if (this.nameList.size() > ((JavaName)obj).size()) {
            return 1;
        }
        int count = 0;
        while (count < this.size()) {
            int comparison = alphaSort.compare((Object)this.nameList.get(count), (Object)((JavaName)obj).get(count));
            if (comparison != 0) {
                return comparison;
            }
            ++count;
        }
        return 0;
    }

    @Override
    public int size() {
        return this.nameList.size();
    }

    @Override
    public boolean isEmpty() {
        return this.nameList.isEmpty();
    }

    @Override
    public Enumeration<String> getAll() {
        return Collections.enumeration(this.nameList);
    }

    @Override
    public String get(int posn) {
        return this.nameList.get(posn);
    }

    @Override
    public Name getPrefix(int posn) {
        return new JavaName(this.nameTranslator, this.nameList.subList(0, posn));
    }

    @Override
    public Name getSuffix(int posn) {
        return new JavaName(this.nameTranslator, this.nameList.subList(posn, this.nameList.size()));
    }

    @Override
    public boolean startsWith(Name n) {
        if (this.nameList.size() < n.size()) {
            return false;
        }
        int count = 0;
        while (count < n.size()) {
            if (!n.get(count).equals(this.nameList.get(count))) {
                return false;
            }
            ++count;
        }
        return true;
    }

    @Override
    public boolean endsWith(Name n) {
        if (this.nameList.size() < n.size()) {
            return false;
        }
        int count = 0;
        while (count < n.size()) {
            if (!n.get(n.size() - (count + 1)).equals(this.nameList.get(this.nameList.size() - (count + 1)))) {
                return false;
            }
            ++count;
        }
        return true;
    }

    @Override
    public Name addAll(Name suffix) throws InvalidNameException {
        int count = 0;
        while (count < suffix.size()) {
            this.nameList.add(suffix.get(count));
            ++count;
        }
        return this;
    }

    @Override
    public Name addAll(int posn, Name n) throws InvalidNameException {
        int count = 0;
        while (count < n.size()) {
            this.nameList.add(posn, n.get(count));
            ++count;
        }
        return this;
    }

    @Override
    public Name add(String comp) throws InvalidNameException {
        this.nameList.add(comp);
        return this;
    }

    @Override
    public Name add(int posn, String comp) throws InvalidNameException {
        this.nameList.add(posn, comp);
        return this;
    }

    @Override
    public Object remove(int posn) throws InvalidNameException {
        return this.nameList.remove(posn);
    }

    @Override
    public Object clone() {
        return new JavaName(this);
    }

    public String toString() {
        return this.nameTranslator.fromExternalNameToExternalString(this);
    }
}

