/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.java;

import javax.naming.Name;
import javax.naming.NameParser;
import javax.naming.NamingException;
import org.smallmind.quorum.namespace.java.JavaName;
import org.smallmind.quorum.namespace.java.backingStore.NameTranslator;

public class JavaNameParser
implements NameParser {
    private NameTranslator nameTranslator;

    public JavaNameParser(NameTranslator nameTranslator) {
        this.nameTranslator = nameTranslator;
    }

    @Override
    public Name parse(String name) throws NamingException {
        JavaName parsedName = new JavaName(this.nameTranslator);
        if (name.equals("")) {
            return parsedName;
        }
        String[] parseArray = name.split("/", -1);
        int count = 0;
        while (count < parseArray.length) {
            if (count == 0) {
                int colonPos = parseArray[count].indexOf(":");
                if (colonPos >= 0) {
                    parsedName.add(parseArray[count].substring(0, colonPos + 1));
                    if (colonPos + 1 < parseArray[count].length()) {
                        parsedName.add(parseArray[count].substring(colonPos + 1));
                    }
                } else {
                    parsedName.add(parseArray[count]);
                }
            } else {
                parsedName.add(parseArray[count]);
            }
            ++count;
        }
        return parsedName;
    }

    public String unparse(Name name) {
        if (name.size() == 0) {
            return "";
        }
        StringBuilder nameBuilder = new StringBuilder();
        int count = 0;
        while (count < name.size()) {
            if (count > 0) {
                nameBuilder.append('/');
            }
            nameBuilder.append(name.get(count));
            ++count;
        }
        return nameBuilder.toString();
    }
}

