/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.concurrent.ConcurrentLinkedQueue;
import javax.management.ObjectName;
import org.smallmind.instrument.ChronometerInstrumentAndReturn;
import org.smallmind.instrument.InstrumentAndReturn;
import org.smallmind.instrument.InstrumentationManager;
import org.smallmind.instrument.MetricProperty;
import org.smallmind.instrument.MetricRegistry;
import org.smallmind.instrument.config.MetricConfiguration;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.PoolManager;
import org.smallmind.quorum.pool.complex.ComplexPoolConfig;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentInstanceFactory;
import org.smallmind.quorum.pool.complex.ComponentPin;
import org.smallmind.quorum.pool.complex.ComponentPinManager;
import org.smallmind.quorum.pool.complex.event.ComponentPoolEventListener;
import org.smallmind.quorum.pool.complex.event.ErrorReportingComponentPoolEvent;
import org.smallmind.quorum.pool.complex.event.LeaseTimeReportingComponentPoolEvent;
import org.smallmind.quorum.pool.complex.jmx.ComponentPoolMonitor;
import org.smallmind.quorum.pool.instrument.MetricInteraction;

public class ComponentPool<C> {
    private final ConcurrentLinkedQueue<ComponentPoolEventListener> componentPoolEventListenerQueue = new ConcurrentLinkedQueue();
    private final ComponentInstanceFactory<C> componentInstanceFactory;
    private final ComponentPinManager<C> componentPinManager;
    private final String name;
    private ComplexPoolConfig complexPoolConfig = new ComplexPoolConfig();

    public ComponentPool(String name, ComponentInstanceFactory<C> componentInstanceFactory) throws ComponentPoolException {
        MetricRegistry metricRegistry;
        MetricConfiguration metricConfiguration;
        this.name = name;
        this.componentInstanceFactory = componentInstanceFactory;
        this.componentPinManager = new ComponentPinManager(this);
        if (PoolManager.getPool() != null && (metricConfiguration = PoolManager.getPool().getMetricConfiguration()) != null && metricConfiguration.isInstrumented() && (metricRegistry = InstrumentationManager.getMetricRegistry()) != null && metricRegistry.getServer() != null) {
            try {
                metricRegistry.getServer().registerMBean(new ComponentPoolMonitor(this), new ObjectName(String.valueOf(metricConfiguration.getMetricDomain().getDomain()) + ":" + "pool=" + name));
            }
            catch (Exception exception) {
                throw new ComponentPoolException(exception);
            }
        }
    }

    public ComponentPool(String name, ComponentInstanceFactory<C> componentInstanceFactory, ComplexPoolConfig complexPoolConfig) throws ComponentPoolException {
        this(name, componentInstanceFactory);
        this.complexPoolConfig = complexPoolConfig;
    }

    public String getPoolName() {
        return this.name;
    }

    public ComponentInstanceFactory<C> getComponentInstanceFactory() {
        return this.componentInstanceFactory;
    }

    public ComplexPoolConfig getComplexPoolConfig() {
        return this.complexPoolConfig;
    }

    public ComponentPool<C> setComplexPoolConfig(ComplexPoolConfig complexPoolConfig) {
        this.complexPoolConfig = complexPoolConfig;
        return this;
    }

    public StackTrace[] getExistentialStackTraces() {
        return this.componentPinManager.getExistentialStackTraces();
    }

    public void addComponentPoolEventListener(ComponentPoolEventListener listener) {
        this.componentPoolEventListenerQueue.add(listener);
    }

    public void removeComponentPoolEventListener(ComponentPoolEventListener listener) {
        this.componentPoolEventListenerQueue.remove(listener);
    }

    public void reportErrorOccurred(Exception exception) {
        ErrorReportingComponentPoolEvent poolEvent = new ErrorReportingComponentPoolEvent(this, exception);
        for (ComponentPoolEventListener listener : this.componentPoolEventListenerQueue) {
            listener.reportErrorOccurred(poolEvent);
        }
    }

    public void reportLeaseTimeNanos(long leaseTimeNanos) {
        LeaseTimeReportingComponentPoolEvent poolEvent = new LeaseTimeReportingComponentPoolEvent(this, leaseTimeNanos);
        for (ComponentPoolEventListener listener : this.componentPoolEventListenerQueue) {
            listener.reportLeaseTime(poolEvent);
        }
    }

    public void startup() throws ComponentPoolException {
        try {
            this.componentInstanceFactory.initialize();
        }
        catch (Exception exception) {
            throw new ComponentPoolException(exception);
        }
        this.componentPinManager.startup();
        try {
            this.componentInstanceFactory.startup();
        }
        catch (Exception exception) {
            throw new ComponentPoolException(exception);
        }
    }

    public void shutdown() throws ComponentPoolException {
        try {
            this.componentInstanceFactory.shutdown();
        }
        catch (Exception exception) {
            throw new ComponentPoolException(exception);
        }
        this.componentPinManager.shutdown();
        try {
            this.componentInstanceFactory.deconstruct();
        }
        catch (Exception exception) {
            throw new ComponentPoolException(exception);
        }
    }

    public C getComponent() throws ComponentPoolException {
        try {
            return (C)InstrumentationManager.execute((InstrumentAndReturn)new ChronometerInstrumentAndReturn<C>(PoolManager.getPool().getMetricConfiguration(), new MetricProperty[]{new MetricProperty("pool", this.getPoolName()), new MetricProperty("event", MetricInteraction.WAITING.getDisplay())}){

                public C withChronometer() throws Exception {
                    return ComponentPool.this.componentPinManager.serve().serve();
                }
            });
        }
        catch (Throwable throwable) {
            throw new ComponentPoolException(throwable);
        }
    }

    public void returnInstance(ComponentInstance<C> componentInstance) {
        this.componentPinManager.process(componentInstance);
    }

    public void terminateInstance(ComponentInstance<C> componentInstance) {
        this.componentPinManager.terminate(componentInstance);
    }

    public void removePin(ComponentPin<C> componentPin, boolean withPrejudice) {
        this.componentPinManager.remove(componentPin, withPrejudice);
    }

    public int getPoolSize() {
        return this.componentPinManager.getPoolSize();
    }

    public int getFreeSize() {
        return this.componentPinManager.getFreeSize();
    }

    public int getProcessingSize() {
        return this.componentPinManager.getProcessingSize();
    }
}

