/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex.jmx;

import java.net.MalformedURLException;
import java.rmi.NotBoundException;
import java.rmi.RemoteException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanRegistration;
import javax.management.MBeanServer;
import javax.management.NotificationBroadcasterSupport;
import javax.management.ObjectName;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.event.ComponentPoolEventListener;
import org.smallmind.quorum.pool.complex.event.ErrorReportingComponentPoolEvent;
import org.smallmind.quorum.pool.complex.event.LeaseTimeReportingComponentPoolEvent;
import org.smallmind.quorum.pool.complex.jmx.ComponentLeaseTimeNotification;
import org.smallmind.quorum.pool.complex.jmx.ComponentPoolMonitorMXBean;
import org.smallmind.quorum.pool.complex.jmx.CreationErrorOccurredNotification;

public class ComponentPoolMonitor
extends NotificationBroadcasterSupport
implements ComponentPoolMonitorMXBean,
MBeanRegistration,
ComponentPoolEventListener {
    private ComponentPool componentPool;
    private ObjectName objectName;

    public ComponentPoolMonitor(ComponentPool componentPool) {
        super(new MBeanNotificationInfo(new String[]{"ERROR_OCCURRED"}, CreationErrorOccurredNotification.class.getName(), "Creation Error Occurred"), new MBeanNotificationInfo(new String[]{"LEASE_TIME"}, ComponentLeaseTimeNotification.class.getName(), "Component Lease Time"));
        this.componentPool = componentPool;
    }

    @Override
    public ObjectName preRegister(MBeanServer mBeanServer, ObjectName objectName) {
        this.componentPool.addComponentPoolEventListener(this);
        this.objectName = objectName;
        return this.objectName;
    }

    @Override
    public void postRegister(Boolean success) {
    }

    @Override
    public void preDeregister() throws MalformedURLException, NotBoundException, RemoteException {
        this.componentPool.removeComponentPoolEventListener(this);
    }

    @Override
    public void postDeregister() {
    }

    @Override
    public void reportErrorOccurred(ErrorReportingComponentPoolEvent event) {
        this.sendNotification(new CreationErrorOccurredNotification(this.objectName, event.getException()));
    }

    @Override
    public void reportLeaseTime(LeaseTimeReportingComponentPoolEvent event) {
        this.sendNotification(new ComponentLeaseTimeNotification(this.objectName, event.getLeaseTimeNanos()));
    }

    @Override
    public String getPoolName() {
        return this.componentPool.getPoolName();
    }

    @Override
    public void startup() throws ComponentPoolException {
        this.componentPool.startup();
    }

    @Override
    public void shutdown() throws ComponentPoolException {
        this.componentPool.shutdown();
    }

    @Override
    public boolean isTestOnCreate() {
        return this.componentPool.getComplexPoolConfig().isTestOnCreate();
    }

    @Override
    public void setTestOnCreate(boolean testOnCreate) {
        this.componentPool.getComplexPoolConfig().setTestOnCreate(testOnCreate);
    }

    @Override
    public boolean isTestOnAcquire() {
        return this.componentPool.getComplexPoolConfig().isTestOnAcquire();
    }

    @Override
    public void setTestOnAcquire(boolean testOnAcquire) {
        this.componentPool.getComplexPoolConfig().setTestOnAcquire(testOnAcquire);
    }

    @Override
    public boolean isReportLeaseTimeNanos() {
        return this.componentPool.getComplexPoolConfig().isReportLeaseTimeNanos();
    }

    @Override
    public void setReportLeaseTimeNanos(boolean reportLeaseTimeNanos) {
        this.componentPool.getComplexPoolConfig().setReportLeaseTimeNanos(reportLeaseTimeNanos);
    }

    @Override
    public boolean isExistentiallyAware() {
        return this.componentPool.getComplexPoolConfig().isExistentiallyAware();
    }

    @Override
    public void setExistentiallyAware(boolean existentiallyAware) {
        this.componentPool.getComplexPoolConfig().setExistentiallyAware(existentiallyAware);
    }

    @Override
    public long getCreationTimeoutMillis() {
        return this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis();
    }

    @Override
    public void setCreationTimeoutMillis(long creationTimeoutMillis) {
        this.componentPool.getComplexPoolConfig().setCreationTimeoutMillis(creationTimeoutMillis);
    }

    @Override
    public int getInitialPoolSize() {
        return this.componentPool.getComplexPoolConfig().getInitialPoolSize();
    }

    @Override
    public int getMinPoolSize() {
        return this.componentPool.getComplexPoolConfig().getMinPoolSize();
    }

    @Override
    public void setMinPoolSize(int minPoolSize) {
        this.componentPool.getComplexPoolConfig().setMinPoolSize(minPoolSize);
    }

    @Override
    public int getMaxPoolSize() {
        return this.componentPool.getComplexPoolConfig().getMaxPoolSize();
    }

    @Override
    public void setMaxPoolSize(int maxPoolSize) {
        this.componentPool.getComplexPoolConfig().setMaxPoolSize(maxPoolSize);
    }

    @Override
    public synchronized long getAcquireWaitTimeMillis() {
        return this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis();
    }

    @Override
    public synchronized void setAcquireWaitTimeMillis(long acquireWaitTimeMillis) {
        this.componentPool.getComplexPoolConfig().setAcquireWaitTimeMillis(acquireWaitTimeMillis);
    }

    @Override
    public int getMaxLeaseTimeSeconds() {
        return this.componentPool.getComplexPoolConfig().getMaxLeaseTimeSeconds();
    }

    @Override
    public void setMaxLeaseTimeSeconds(int leaseTimeSeconds) {
        this.componentPool.getComplexPoolConfig().setMaxLeaseTimeSeconds(leaseTimeSeconds);
    }

    @Override
    public int getMaxIdleTimeSeconds() {
        return this.componentPool.getComplexPoolConfig().getMaxIdleTimeSeconds();
    }

    @Override
    public void setMaxIdleTimeSeconds(int maxIdleTimeSeconds) {
        this.componentPool.getComplexPoolConfig().setMaxIdleTimeSeconds(maxIdleTimeSeconds);
    }

    @Override
    public int getUnReturnedElementTimeoutSeconds() {
        return this.componentPool.getComplexPoolConfig().getUnReturnedElementTimeoutSeconds();
    }

    @Override
    public void setUnReturnedElementTimeoutSeconds(int unReturnedElementTimeoutSeconds) {
        this.componentPool.getComplexPoolConfig().setUnReturnedElementTimeoutSeconds(unReturnedElementTimeoutSeconds);
    }

    @Override
    public int getPoolSize() {
        return this.componentPool.getPoolSize();
    }

    @Override
    public int getFreeSize() {
        return this.componentPool.getFreeSize();
    }

    @Override
    public int getProcessingSize() {
        return this.componentPool.getProcessingSize();
    }
}

