/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.bucket;

import java.util.HashMap;
import org.smallmind.nutsnbolts.time.Stint;
import org.smallmind.quorum.bucket.BucketFactory;
import org.smallmind.quorum.bucket.BucketKey;
import org.smallmind.quorum.bucket.BucketQuantifier;
import org.smallmind.quorum.bucket.BucketSelector;

public class TokenBucket<T> {
    private final BucketQuantifier<T> quantifier;
    private final BucketSelector<T> selector;
    private final double limit;
    private final double refillPerNanosecond;
    private HashMap<BucketKey<T>, TokenBucket<T>> children;
    private double capacity;
    private long timestamp;

    public TokenBucket(BucketQuantifier<T> quantifier, BucketSelector<T> selector, double limit, double refillQuantity, Stint refillRate) {
        this.quantifier = quantifier;
        this.selector = selector;
        this.limit = limit;
        this.refillPerNanosecond = refillQuantity / (double)refillRate.getTimeUnit().toNanos(refillRate.getTime());
        System.out.println(this.refillPerNanosecond);
        this.capacity = limit;
        this.timestamp = System.nanoTime();
    }

    public synchronized void add(BucketKey<T> key, BucketFactory<T> factory) {
        if (this.children == null) {
            this.children = new HashMap();
        }
        if (!this.children.containsKey(key)) {
            this.children.put(key, factory.create());
        }
    }

    public synchronized boolean allowed(T input) {
        return this.allowed(System.nanoTime(), input);
    }

    private synchronized boolean allowed(long current, T input) {
        TokenBucket<T> child;
        double d;
        if (current > this.timestamp) {
            double d2;
            this.capacity += (double)(current - this.timestamp) * this.refillPerNanosecond;
            if (d2 > this.limit) {
                this.capacity = this.limit;
            }
            this.timestamp = current;
        }
        double quantity = this.quantifier.quantity(input);
        if (d <= this.capacity && (this.children == null || this.children.isEmpty() || (child = this.children.get(this.selector.selection(input))) == null || child.allowed(current, input))) {
            this.capacity -= quantity;
            return true;
        }
        return false;
    }
}

