/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.smallmind.claxon.registry.Instrument;
import org.smallmind.claxon.registry.Tag;
import org.smallmind.claxon.registry.meter.LazyBuilder;
import org.smallmind.claxon.registry.meter.MeterBuilder;
import org.smallmind.claxon.registry.meter.SpeedometerBuilder;
import org.smallmind.claxon.registry.meter.TachometerBuilder;
import org.smallmind.nutsnbolts.lang.StackTrace;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.complex.ClaxonTag;
import org.smallmind.quorum.pool.complex.ComponentCreationException;
import org.smallmind.quorum.pool.complex.ComponentCreationWorker;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPin;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.quorum.pool.complex.ComponentValidationException;
import org.smallmind.quorum.pool.complex.DeconstructionQueue;
import org.smallmind.scribe.pen.LoggerManager;

public class ComponentPinManager<C> {
    private final ComponentPool<C> componentPool;
    private final HashMap<ComponentInstance<C>, ComponentPin<C>> backingMap = new HashMap();
    private final LinkedBlockingQueue<ComponentPin<C>> freeQueue = new LinkedBlockingQueue();
    private final ReentrantReadWriteLock backingLock = new ReentrantReadWriteLock();
    private final DeconstructionQueue deconstructionQueue = new DeconstructionQueue();
    private final AtomicReference<State> stateRef = new AtomicReference<State>(State.STOPPED);
    private final AtomicInteger size = new AtomicInteger(0);

    public ComponentPinManager(ComponentPool<C> componentPool) {
        this.componentPool = componentPool;
    }

    public void startup() throws ComponentPoolException {
        if (this.stateRef.compareAndSet(State.STOPPED, State.STARTING)) {
            this.deconstructionQueue.startup();
            this.backingLock.writeLock().lock();
            try {
                while (this.backingMap.size() < Math.max(this.componentPool.getComplexPoolConfig().getMinPoolSize(), this.componentPool.getComplexPoolConfig().getInitialPoolSize())) {
                    ComponentInstance<C> componentInstance = this.componentPool.getComponentInstanceFactory().createInstance(this.componentPool);
                    ComponentPin<C> componentPin = new ComponentPin<C>(this.componentPool, this.deconstructionQueue, componentInstance);
                    this.backingMap.put(componentInstance, componentPin);
                    this.freeQueue.put(componentPin);
                }
                this.size.set(this.backingMap.size());
                this.stateRef.set(State.STARTED);
                this.trackSize();
            }
            catch (Exception exception) {
                this.freeQueue.clear();
                this.backingMap.clear();
                this.size.set(0);
                this.stateRef.set(State.STOPPED);
                throw new ComponentPoolException(exception);
            }
            finally {
                this.backingLock.writeLock().unlock();
            }
        }
        try {
            while (State.STARTING.equals((Object)this.stateRef.get())) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ComponentPoolException(interruptedException);
        }
    }

    public ComponentPin<C> serve() throws ComponentPoolException {
        ComponentPin<C> componentPin;
        if (!State.STARTED.equals((Object)this.stateRef.get())) {
            throw new ComponentPoolException("%s is not in the 'started' state", ComponentPool.class.getSimpleName());
        }
        while ((componentPin = this.freeQueue.poll()) != null) {
            if (this.componentPool.getComplexPoolConfig().isTestOnAcquire() && !componentPin.getComponentInstance().validate()) {
                this.remove(componentPin, true);
                continue;
            }
            this.trackSize();
            return componentPin;
        }
        componentPin = this.addComponentPin(true);
        if (componentPin != null) {
            this.trackSize();
            return componentPin;
        }
        try {
            long acquireWaitTimeMillis = this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis();
            long start = System.currentTimeMillis();
            while (acquireWaitTimeMillis > 0L && (componentPin = this.freeQueue.poll(acquireWaitTimeMillis, TimeUnit.MILLISECONDS)) != null) {
                if (this.componentPool.getComplexPoolConfig().isTestOnAcquire() && !componentPin.getComponentInstance().validate()) {
                    this.remove(componentPin, true);
                    acquireWaitTimeMillis = this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis() - (System.currentTimeMillis() - start);
                    continue;
                }
                this.trackSize();
                return componentPin;
            }
        }
        catch (InterruptedException interruptedException) {
            throw new ComponentPoolException(interruptedException);
        }
        this.trackTimeout();
        throw new ComponentPoolException("Exceeded the maximum acquire wait time(%d)", this.componentPool.getComplexPoolConfig().getAcquireWaitTimeMillis());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentPin<C> addComponentPin(boolean forced) throws ComponentCreationException, ComponentValidationException {
        if (State.STARTED.equals((Object)this.stateRef.get())) {
            int minPoolSize = this.componentPool.getComplexPoolConfig().getMinPoolSize();
            int maxPoolSize = this.componentPool.getComplexPoolConfig().getMaxPoolSize();
            int currentSize = this.size.get();
            if (!(!forced && currentSize >= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                this.backingLock.writeLock().lock();
                try {
                    currentSize = this.size.get();
                    if (!(!forced && currentSize >= minPoolSize || maxPoolSize != 0 && currentSize >= maxPoolSize)) {
                        ComponentInstance<C> componentInstance = this.manufactureComponentInstance();
                        ComponentPin<C> componentPin = new ComponentPin<C>(this.componentPool, this.deconstructionQueue, componentInstance);
                        this.backingMap.put(componentInstance, componentPin);
                        this.size.incrementAndGet();
                        ComponentPin<C> componentPin2 = componentPin;
                        return componentPin2;
                    }
                }
                finally {
                    this.backingLock.writeLock().unlock();
                }
            }
        }
        return null;
    }

    private ComponentInstance<C> manufactureComponentInstance() throws ComponentCreationException, ComponentValidationException {
        ComponentInstance<C> componentInstance;
        try {
            if (this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis() > 0L) {
                ComponentCreationWorker<C> creationWorker = new ComponentCreationWorker<C>(this.componentPool);
                Thread workerThread = new Thread(creationWorker);
                workerThread.setDaemon(true);
                workerThread.start();
                workerThread.join(this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis());
                if (creationWorker.abort()) {
                    throw new ComponentCreationException("Exceeded timeout(%d) waiting on element creation (pool size = %d, free size = %d)", this.componentPool.getComplexPoolConfig().getCreationTimeoutMillis(), this.getPoolSize(), this.getFreeSize());
                }
                componentInstance = creationWorker.getComponentInstance();
            } else {
                componentInstance = this.componentPool.getComponentInstanceFactory().createInstance(this.componentPool);
            }
        }
        catch (ComponentCreationException componentCreationException) {
            throw componentCreationException;
        }
        catch (Exception exception) {
            throw new ComponentCreationException(exception);
        }
        if (this.componentPool.getComplexPoolConfig().isTestOnCreate() && !componentInstance.validate()) {
            throw new ComponentValidationException("A new element was required, but failed to validate", new Object[0]);
        }
        return componentInstance;
    }

    public void remove(ComponentPin<C> componentPin, boolean withPrejudice) {
        if (this.freeQueue.remove(componentPin) || withPrejudice) {
            this.terminate(componentPin.getComponentInstance());
            this.trackSize();
        }
    }

    public void process(ComponentInstance<C> componentInstance) {
        ComponentPin<C> componentPin;
        this.backingLock.readLock().lock();
        try {
            componentPin = this.backingMap.get(componentInstance);
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        if (componentPin != null) {
            componentPin.free();
            if (componentPin.isTerminated()) {
                this.terminate(componentPin.getComponentInstance());
            } else if (State.STARTED.equals((Object)this.stateRef.get())) {
                try {
                    this.freeQueue.put(componentPin);
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)interruptedException);
                }
            }
            this.trackSize();
        }
    }

    public void terminate(ComponentInstance<C> componentInstance) {
        ComponentPin<C> componentPin;
        this.backingLock.writeLock().lock();
        try {
            componentPin = this.backingMap.remove(componentInstance);
        }
        finally {
            this.backingLock.writeLock().unlock();
        }
        if (componentPin != null) {
            this.size.decrementAndGet();
            componentPin.fizzle();
            try {
                componentPin.getComponentInstance().close();
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)exception);
            }
            try {
                ComponentPin<C> replacementComponentPin = this.addComponentPin(false);
                if (replacementComponentPin != null) {
                    this.freeQueue.put(replacementComponentPin);
                }
            }
            catch (Exception exception) {
                LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)exception);
            }
            this.trackSize();
        }
    }

    public void shutdown() throws ComponentPoolException {
        if (this.stateRef.compareAndSet(State.STARTED, State.STOPPING)) {
            while (this.size.get() > 0) {
                ComponentInstance[] activeComponents;
                this.backingLock.readLock().lock();
                try {
                    Set<ComponentInstance<C>> keys = this.backingMap.keySet();
                    activeComponents = new ComponentInstance[keys.size()];
                    keys.toArray(activeComponents);
                }
                finally {
                    this.backingLock.readLock().unlock();
                }
                for (ComponentInstance activeComponent : activeComponents) {
                    this.terminate(activeComponent);
                }
            }
            this.freeQueue.clear();
            try {
                this.deconstructionQueue.shutdown();
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ComponentPinManager.class).error((Throwable)interruptedException);
            }
            this.stateRef.set(State.STOPPED);
        } else {
            try {
                while (State.STOPPING.equals((Object)this.stateRef.get())) {
                    Thread.sleep(100L);
                }
            }
            catch (InterruptedException interruptedException) {
                throw new ComponentPoolException(interruptedException);
            }
        }
    }

    public int getPoolSize() {
        return this.size.get();
    }

    public int getFreeSize() {
        return this.freeQueue.size();
    }

    public int getProcessingSize() {
        return this.getPoolSize() - this.getFreeSize();
    }

    private void trackSize() {
        int freeSize = this.freeQueue.size();
        Instrument.with(ComponentPinManager.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("pool", this.componentPool.getPoolName()), new Tag("size", ClaxonTag.FREE.getDisplay())}).update((long)freeSize);
        Instrument.with(ComponentPinManager.class, (MeterBuilder)LazyBuilder.instance(SpeedometerBuilder::new), (Tag[])new Tag[]{new Tag("pool", this.componentPool.getPoolName()), new Tag("size", ClaxonTag.PROCESSING.getDisplay())}).update((long)(this.getPoolSize() - freeSize));
    }

    private void trackTimeout() {
        Instrument.with(ComponentPinManager.class, (MeterBuilder)LazyBuilder.instance(TachometerBuilder::new), (Tag[])new Tag[]{new Tag("pool", this.componentPool.getPoolName()), new Tag("event", ClaxonTag.TIMEOUT.getDisplay())}).update(1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StackTrace[] getExistentialStackTraces() {
        LinkedList<StackTrace> stackTraceList = new LinkedList<StackTrace>();
        this.backingLock.readLock().lock();
        try {
            for (ComponentPin<C> componentPin : this.backingMap.values()) {
                if (this.freeQueue.contains(componentPin)) continue;
                stackTraceList.add(new StackTrace(componentPin.getExistentialStackTrace()));
            }
        }
        finally {
            this.backingLock.readLock().unlock();
        }
        StackTrace[] stackTraces = new StackTrace[stackTraceList.size()];
        stackTraceList.toArray(stackTraces);
        return stackTraces;
    }

    private static enum State {
        STOPPED,
        STARTING,
        STARTED,
        STOPPING;

    }
}

