/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.java;

import java.util.Hashtable;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.NameClassPair;
import javax.naming.NameNotFoundException;
import javax.naming.NameParser;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.OperationNotSupportedException;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.smallmind.quorum.namespace.java.ContextNamePair;
import org.smallmind.quorum.namespace.java.JavaNameParser;
import org.smallmind.quorum.namespace.java.JavaNamingEnumeration;
import org.smallmind.quorum.namespace.java.PooledJavaContext;
import org.smallmind.quorum.namespace.java.backingStore.NameTranslator;

public class JavaContext
implements DirContext {
    public static final String CONNECTION_DETAILS = "org.smallmind.quorum.namespace.java.connection details";
    public static final String CONTEXT_STORE = "org.smallmind.quorum.namespace.java.store";
    public static final String CONTEXT_MODIFIABLE = "org.smallmind.quorum.namespace.java.modifiable";
    public static final String POOLED_CONNECTION = "org.smallmind.quorum.namespace.java.pooled";
    private final Hashtable<String, Object> environment;
    private final DirContext internalContext;
    private final NameTranslator nameTranslator;
    private final JavaNameParser nameParser;
    private final boolean modifiable;
    private final boolean pooled;

    protected JavaContext(NameTranslator nameTranslator, Hashtable<String, Object> environment, boolean modifiable, boolean pooled) {
        this.nameTranslator = nameTranslator;
        this.environment = environment;
        this.modifiable = modifiable;
        this.pooled = pooled;
        this.internalContext = null;
        this.nameParser = new JavaNameParser(nameTranslator);
    }

    protected JavaContext(Hashtable<String, Object> environment, DirContext internalContext, NameTranslator nameTranslator, JavaNameParser nameParser, boolean modifiable) {
        this.environment = environment;
        this.internalContext = internalContext;
        this.nameTranslator = nameTranslator;
        this.nameParser = nameParser;
        this.modifiable = modifiable;
        this.pooled = false;
    }

    public static JavaContext insureContext(JavaContext javaContext, String namingPath) throws NamingException {
        JavaContext lastContext = javaContext;
        String[] pathArray = namingPath.split("/", -1);
        StringBuilder pathSoFar = new StringBuilder();
        for (int count = pathArray.length - 1; count >= 0; --count) {
            if (pathSoFar.length() > 0) {
                pathSoFar.insert(0, '/');
            }
            pathSoFar.insert(0, pathArray[count]);
            try {
                lastContext = (JavaContext)javaContext.lookup(pathSoFar.toString());
                continue;
            }
            catch (NameNotFoundException n) {
                lastContext = (JavaContext)javaContext.createSubcontext(pathSoFar.toString());
            }
        }
        return lastContext;
    }

    @Override
    public Object lookup(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        Object lookupObject = contextNamePair.getContext().lookup(contextNamePair.getName());
        if (lookupObject.getClass().equals(contextNamePair.getContext().getClass())) {
            if (this.pooled) {
                return new PooledJavaContext(this.environment, (DirContext)lookupObject, this.nameTranslator, this.nameParser, this.modifiable);
            }
            return new JavaContext(this.environment, (DirContext)lookupObject, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return lookupObject;
    }

    @Override
    public Object lookup(String name) throws NamingException {
        return this.lookup(this.nameParser.parse(name));
    }

    @Override
    public void bind(Name name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().bind(contextNamePair.getName(), obj);
    }

    @Override
    public void bind(String name, Object obj) throws NamingException {
        this.bind(this.nameParser.parse(name), obj);
    }

    @Override
    public void rebind(Name name, Object obj) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().rebind(contextNamePair.getName(), obj);
    }

    @Override
    public void rebind(String name, Object obj) throws NamingException {
        this.rebind(this.nameParser.parse(name), obj);
    }

    @Override
    public void unbind(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().unbind(contextNamePair.getName());
    }

    @Override
    public void unbind(String name) throws NamingException {
        this.unbind(this.nameParser.parse(name));
    }

    @Override
    public void rename(Name oldName, Name newName) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, oldName);
        contextNamePair.getContext().rename(contextNamePair.getName(), this.nameTranslator.fromInternalNameToExternalName(newName));
    }

    @Override
    public void rename(String oldName, String newName) throws NamingException {
        this.rename(this.nameParser.parse(oldName), this.nameParser.parse(newName));
    }

    @Override
    public NamingEnumeration<NameClassPair> list(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<NameClassPair> internalEnumeration = contextNamePair.getContext().list(contextNamePair.getName());
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<NameClassPair>(NameClassPair.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<NameClassPair> list(String name) throws NamingException {
        return this.list(this.nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<Binding> listBindings(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<Binding> internalEnumeration = contextNamePair.getContext().listBindings(contextNamePair.getName());
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<Binding>(Binding.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<Binding> listBindings(String name) throws NamingException {
        return this.listBindings(this.nameParser.parse(name));
    }

    @Override
    public void destroySubcontext(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().destroySubcontext(contextNamePair.getName());
    }

    @Override
    public void destroySubcontext(String name) throws NamingException {
        this.destroySubcontext(this.nameParser.parse(name));
    }

    @Override
    public Context createSubcontext(Name name) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        Context createdContext = contextNamePair.getContext().createSubcontext(contextNamePair.getName());
        return new JavaContext(this.environment, (DirContext)createdContext, this.nameTranslator, this.nameParser, this.modifiable);
    }

    @Override
    public Context createSubcontext(String name) throws NamingException {
        return this.createSubcontext(this.nameParser.parse(name));
    }

    @Override
    public Object lookupLink(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        Object lookupObject = contextNamePair.getContext().lookupLink(contextNamePair.getName());
        if (lookupObject.getClass().equals(contextNamePair.getContext().getClass())) {
            return new JavaContext(this.environment, (DirContext)lookupObject, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return lookupObject;
    }

    @Override
    public Object lookupLink(String name) throws NamingException {
        return this.lookupLink(this.nameParser.parse(name));
    }

    @Override
    public NameParser getNameParser(Name name) throws NamingException {
        return this.nameParser;
    }

    @Override
    public NameParser getNameParser(String name) throws NamingException {
        return this.getNameParser(this.nameParser.parse(name));
    }

    @Override
    public Name composeName(Name name, Name prefix) throws NamingException {
        return ((Name)prefix.clone()).addAll(name);
    }

    @Override
    public String composeName(String name, String prefix) throws NamingException {
        return this.nameParser.unparse(this.composeName(this.nameParser.parse(name), this.nameParser.parse(prefix)));
    }

    @Override
    public Object addToEnvironment(String propName, Object propVal) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        Object prevObject = this.environment.get(propName);
        this.environment.put(propName, propVal);
        return prevObject;
    }

    @Override
    public Object removeFromEnvironment(String propName) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        return this.environment.remove(propName);
    }

    public Hashtable getEnvironment() throws NamingException {
        return this.environment;
    }

    @Override
    public void close() throws NamingException {
        if (this.internalContext != null) {
            this.internalContext.close();
        }
    }

    public void finalize() throws NamingException {
        this.close();
    }

    @Override
    public String getNameInNamespace() throws NamingException {
        return this.nameTranslator.fromAbsoluteExternalStringToInternalString(this.internalContext.getNameInNamespace());
    }

    @Override
    public Attributes getAttributes(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        return contextNamePair.getContext().getAttributes(contextNamePair.getName());
    }

    @Override
    public Attributes getAttributes(String name) throws NamingException {
        return this.getAttributes(this.nameParser.parse(name));
    }

    @Override
    public Attributes getAttributes(Name name, String[] attrIds) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        return contextNamePair.getContext().getAttributes(contextNamePair.getName(), attrIds);
    }

    @Override
    public Attributes getAttributes(String name, String[] attrIds) throws NamingException {
        return this.getAttributes(this.nameParser.parse(name), attrIds);
    }

    @Override
    public void modifyAttributes(Name name, int mod_op, Attributes attrs) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().modifyAttributes(contextNamePair.getName(), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(String name, int mod_op, Attributes attrs) throws NamingException {
        this.modifyAttributes(this.nameParser.parse(name), mod_op, attrs);
    }

    @Override
    public void modifyAttributes(Name name, ModificationItem[] mods) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().modifyAttributes(contextNamePair.getName(), mods);
    }

    @Override
    public void modifyAttributes(String name, ModificationItem[] mods) throws NamingException {
        this.modifyAttributes(this.nameParser.parse(name), mods);
    }

    @Override
    public void bind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().bind(contextNamePair.getName(), obj, attrs);
    }

    @Override
    public void bind(String name, Object obj, Attributes attrs) throws NamingException {
        this.bind(this.nameParser.parse(name), obj, attrs);
    }

    @Override
    public void rebind(Name name, Object obj, Attributes attrs) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        contextNamePair.getContext().rebind(contextNamePair.getName(), obj, attrs);
    }

    @Override
    public void rebind(String name, Object obj, Attributes attrs) throws NamingException {
        this.rebind(this.nameParser.parse(name), obj, attrs);
    }

    @Override
    public DirContext createSubcontext(Name name, Attributes attrs) throws NamingException {
        if (!this.modifiable) {
            throw new OperationNotSupportedException("This backing store is not modifiable");
        }
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        DirContext createdContext = contextNamePair.getContext().createSubcontext(contextNamePair.getName(), attrs);
        return new JavaContext(this.environment, createdContext, this.nameTranslator, this.nameParser, this.modifiable);
    }

    @Override
    public DirContext createSubcontext(String name, Attributes attrs) throws NamingException {
        return this.createSubcontext(this.nameParser.parse(name), attrs);
    }

    @Override
    public DirContext getSchema(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        return contextNamePair.getContext().getSchema(contextNamePair.getName());
    }

    @Override
    public DirContext getSchema(String name) throws NamingException {
        return this.getSchema(this.nameParser.parse(name));
    }

    @Override
    public DirContext getSchemaClassDefinition(Name name) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        return contextNamePair.getContext().getSchemaClassDefinition(contextNamePair.getName());
    }

    @Override
    public DirContext getSchemaClassDefinition(String name) throws NamingException {
        return this.getSchemaClassDefinition(this.nameParser.parse(name));
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<SearchResult> internalEnumeration = contextNamePair.getContext().search(contextNamePair.getName(), matchingAttributes, attributesToReturn);
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<SearchResult>(SearchResult.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes, String[] attributesToReturn) throws NamingException {
        return this.search(this.nameParser.parse(name), matchingAttributes, attributesToReturn);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, Attributes matchingAttributes) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<SearchResult> internalEnumeration = contextNamePair.getContext().search(contextNamePair.getName(), matchingAttributes);
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<SearchResult>(SearchResult.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, Attributes matchingAttributes) throws NamingException {
        return this.search(this.nameParser.parse(name), matchingAttributes);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filter, SearchControls cons) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<SearchResult> internalEnumeration = contextNamePair.getContext().search(contextNamePair.getName(), filter, cons);
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<SearchResult>(SearchResult.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filter, SearchControls cons) throws NamingException {
        return this.search(this.nameParser.parse(name), filter, cons);
    }

    @Override
    public NamingEnumeration<SearchResult> search(Name name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        ContextNamePair contextNamePair = this.nameTranslator.fromInternalNameToExternalContext(this.internalContext, name);
        NamingEnumeration<SearchResult> internalEnumeration = contextNamePair.getContext().search(contextNamePair.getName(), filterExpr, filterArgs, cons);
        if (internalEnumeration != null) {
            return new JavaNamingEnumeration<SearchResult>(SearchResult.class, internalEnumeration, contextNamePair.getContext().getClass(), this.environment, this.nameTranslator, this.nameParser, this.modifiable);
        }
        return null;
    }

    @Override
    public NamingEnumeration<SearchResult> search(String name, String filterExpr, Object[] filterArgs, SearchControls cons) throws NamingException {
        return this.search(this.nameParser.parse(name), filterExpr, filterArgs, cons);
    }
}

