/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.java;

import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import javax.naming.Binding;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import org.smallmind.quorum.namespace.java.JavaNameParser;
import org.smallmind.quorum.namespace.java.NamingEnumerationUtility;
import org.smallmind.quorum.namespace.java.backingStore.NameTranslator;

public class JavaNamingEnumeration<T>
implements NamingEnumeration<T> {
    private static final Class[] SEARCH_RESULT_SIGNATURE = new Class[]{String.class, String.class, Object.class, Attributes.class, Boolean.class};
    private static final Class[] BINDING_SIGNATURE = new Class[]{String.class, String.class, Object.class, Boolean.class};
    private static final Class[] NAME_CLASS_PAIR_SIGNATURE = new Class[]{String.class, String.class, Boolean.class};
    private final NamingEnumeration internalEnumeration;
    private final Class<T> typeClass;
    private final Class internalDirContextClass;
    private final Hashtable<String, Object> environment;
    private final NameTranslator nameTranslator;
    private final JavaNameParser nameParser;
    private final boolean modifiable;

    public JavaNamingEnumeration(Class<T> typeClass, NamingEnumeration<T> internalEnumeration, Class internalDirContextClass, Hashtable<String, Object> environment, NameTranslator nameTranslator, JavaNameParser nameParser, boolean modifiable) {
        this.typeClass = typeClass;
        this.internalEnumeration = internalEnumeration;
        this.internalDirContextClass = internalDirContextClass;
        this.environment = environment;
        this.nameTranslator = nameTranslator;
        this.nameParser = nameParser;
        this.modifiable = modifiable;
    }

    @Override
    public boolean hasMoreElements() {
        try {
            return this.hasMore();
        }
        catch (NamingException n) {
            return false;
        }
    }

    @Override
    public T nextElement() {
        try {
            return this.next();
        }
        catch (NamingException n) {
            throw new NoSuchElementException("There are no more items within this Enumeration");
        }
    }

    @Override
    public T next() throws NamingException {
        Object enumObject = this.internalEnumeration.next();
        boolean isRelative = ((NameClassPair)enumObject).isRelative();
        String name = NamingEnumerationUtility.convertName(((NameClassPair)enumObject).getName(), this.nameTranslator);
        String className = NamingEnumerationUtility.convertClassName(((NameClassPair)enumObject).getClassName(), this.internalDirContextClass);
        try {
            if (enumObject instanceof SearchResult) {
                Object boundObject = NamingEnumerationUtility.convertObject(((SearchResult)enumObject).getObject(), this.internalDirContextClass, this.environment, this.nameTranslator, this.nameParser, this.modifiable);
                Attributes resultAttributes = ((SearchResult)enumObject).getAttributes();
                Constructor<T> typeConstructor = this.typeClass.getConstructor(SEARCH_RESULT_SIGNATURE);
                return typeConstructor.newInstance(name, className, boundObject, resultAttributes, isRelative);
            }
            if (enumObject instanceof Binding) {
                Object boundObject = NamingEnumerationUtility.convertObject(((Binding)enumObject).getObject(), this.internalDirContextClass, this.environment, this.nameTranslator, this.nameParser, this.modifiable);
                Constructor<T> typeConstructor = this.typeClass.getConstructor(BINDING_SIGNATURE);
                return typeConstructor.newInstance(name, className, boundObject, isRelative);
            }
            if (enumObject instanceof NameClassPair) {
                Constructor<T> typeConstructor = this.typeClass.getConstructor(NAME_CLASS_PAIR_SIGNATURE);
                return typeConstructor.newInstance(name, className, isRelative);
            }
        }
        catch (Exception e) {
            NamingException namingException = new NamingException(e.getMessage());
            namingException.setRootCause(e);
            throw namingException;
        }
        return this.typeClass.cast(enumObject);
    }

    @Override
    public boolean hasMore() throws NamingException {
        return this.internalEnumeration.hasMore();
    }

    @Override
    public void close() throws NamingException {
        this.internalEnumeration.close();
    }
}

