/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.juggler;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.smallmind.quorum.juggler.BlackList;
import org.smallmind.quorum.juggler.BlacklistEntry;
import org.smallmind.quorum.juggler.JugglerResourceCreationException;
import org.smallmind.quorum.juggler.JugglerResourceException;
import org.smallmind.quorum.juggler.JugglingPin;
import org.smallmind.quorum.juggler.JugglingPinFactory;
import org.smallmind.quorum.juggler.NoAvailableJugglerResourceException;
import org.smallmind.scribe.pen.LoggerManager;

public class Juggler<P, R>
implements BlackList<R> {
    private final SecureRandom random = new SecureRandom();
    private final JugglingPinFactory<P, R> jugglingPinFactory;
    private final P[] providers;
    private final Class<P> providerClass;
    private final Class<R> resourceClass;
    private final int recoveryCheckSeconds;
    private ProviderRecoveryWorker recoveryWorker = null;
    private ArrayList<JugglingPin<R>> sourcePins;
    private ArrayList<JugglingPin<R>> targetPins;
    private ConcurrentSkipListMap<Long, BlacklistEntry<R>> blacklistMap;
    private State state = State.DECONSTRUCTED;

    public Juggler(Class<P> providerClass, Class<R> resourceClass, int recoveryCheckSeconds, JugglingPinFactory<P, R> jugglingPinFactory, P provider, int size) {
        this(providerClass, resourceClass, recoveryCheckSeconds, jugglingPinFactory, Juggler.generateArray(provider, providerClass, size));
    }

    public Juggler(Class<P> providerClass, Class<R> resourceClass, int recoveryCheckSeconds, JugglingPinFactory<P, R> jugglingPinFactory, P ... providers) {
        this.providerClass = providerClass;
        this.resourceClass = resourceClass;
        this.recoveryCheckSeconds = recoveryCheckSeconds;
        this.jugglingPinFactory = jugglingPinFactory;
        this.providers = providers;
    }

    private static <P> P[] generateArray(P provider, Class<P> providerClass, int size) {
        Object[] array = (Object[])Array.newInstance(providerClass, size);
        Arrays.fill(array, provider);
        return array;
    }

    public synchronized void initialize() throws JugglerResourceCreationException {
        if (this.state.equals((Object)State.DECONSTRUCTED)) {
            this.sourcePins = new ArrayList(this.providers.length);
            this.targetPins = new ArrayList(this.providers.length);
            this.blacklistMap = new ConcurrentSkipListMap();
            for (P provider : this.providers) {
                this.targetPins.add(this.jugglingPinFactory.createJugglingPin(provider, this.resourceClass));
            }
            while (!this.targetPins.isEmpty()) {
                this.sourcePins.add(this.targetPins.remove(this.random.nextInt(this.targetPins.size())));
            }
            this.state = State.INITIALIZED;
        }
    }

    public synchronized void startup() {
        this.startup(null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void startup(Method method, Object ... args) {
        if (this.state.equals((Object)State.INITIALIZED)) {
            Iterator<JugglingPin<R>> sourcePinIter = this.sourcePins.iterator();
            while (sourcePinIter.hasNext()) {
                JugglingPin<R> pin = sourcePinIter.next();
                try {
                    pin.start(method, args);
                }
                catch (JugglerResourceException jugglerResourceException) {
                    try {
                        LoggerManager.getLogger(Juggler.class).error((Throwable)((Object)jugglerResourceException));
                    }
                    finally {
                        sourcePinIter.remove();
                        this.blacklistMap.put(System.currentTimeMillis(), new BlacklistEntry<R>(pin, (Throwable)((Object)jugglerResourceException)));
                    }
                }
            }
            if (this.recoveryCheckSeconds > 0) {
                this.recoveryWorker = new ProviderRecoveryWorker(this.recoveryCheckSeconds);
                Thread recoveryThread = new Thread(this.recoveryWorker);
                recoveryThread.setDaemon(true);
                recoveryThread.start();
            }
            this.state = State.STARTED;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized R pickResource() throws NoAvailableJugglerResourceException {
        if (!this.state.equals((Object)State.INITIALIZED) && !this.state.equals((Object)State.STARTED)) {
            throw new IllegalStateException("Juggler must be in the initialized or started state");
        }
        while (!this.sourcePins.isEmpty() || !this.targetPins.isEmpty()) {
            if (this.sourcePins.isEmpty()) {
                ArrayList<JugglingPin<R>> tempPins = this.sourcePins;
                this.sourcePins = this.targetPins;
                this.targetPins = tempPins;
            }
            JugglingPin<R> pin = this.sourcePins.remove(this.random.nextInt(this.sourcePins.size()));
            try {
                R resource = pin.obtain();
                this.targetPins.add(pin);
                return resource;
            }
            catch (Exception exception) {
                try {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
                finally {
                    this.blacklistMap.put(System.currentTimeMillis(), new BlacklistEntry<R>(pin, exception));
                }
            }
        }
        throw this.generateTerminatingException();
    }

    private NoAvailableJugglerResourceException generateTerminatingException() {
        NoAvailableJugglerResourceException noAvailableJugglerResourceException = null;
        boolean first = true;
        for (BlacklistEntry blacklistEntry : this.blacklistMap.descendingMap().values()) {
            if (first) {
                noAvailableJugglerResourceException = new NoAvailableJugglerResourceException(blacklistEntry.getThrowable(), "All available resources(%s) have been black listed", this.providerClass.getSimpleName());
            } else {
                noAvailableJugglerResourceException.addSuppressed(blacklistEntry.getThrowable());
            }
            first = false;
        }
        return noAvailableJugglerResourceException;
    }

    @Override
    public synchronized void addToBlackList(BlacklistEntry<R> blacklistEntry) {
        if (this.sourcePins.remove(blacklistEntry.getJugglingPin())) {
            this.blacklistMap.put(System.currentTimeMillis(), blacklistEntry);
            LoggerManager.getLogger(Juggler.class).info("Added resource(%s) to black list", new Object[]{blacklistEntry.getJugglingPin().describe()});
        } else if (this.targetPins.remove(blacklistEntry.getJugglingPin())) {
            this.blacklistMap.put(System.currentTimeMillis(), blacklistEntry);
            LoggerManager.getLogger(Juggler.class).info("Added resource(%s) to black list", new Object[]{blacklistEntry.getJugglingPin().describe()});
        }
    }

    public synchronized void shutdown() {
        this.shutdown(null, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void shutdown(Method method, Object ... args) {
        if (this.state.equals((Object)State.STARTED)) {
            if (this.recoveryWorker != null) {
                try {
                    this.recoveryWorker.abort();
                }
                catch (InterruptedException interruptedException) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)interruptedException);
                }
            }
            for (JugglingPin<R> pin : this.sourcePins) {
                try {
                    pin.stop(method, args);
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
            }
            while (!this.targetPins.isEmpty()) {
                JugglingPin<R> pin = this.targetPins.remove(0);
                try {
                    pin.stop(method, args);
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
                finally {
                    this.sourcePins.add(pin);
                }
            }
            this.state = State.STOPPED;
        }
    }

    public synchronized void deconstruct() {
        this.deconstruct(null, new Object[0]);
    }

    public synchronized void deconstruct(Method method, Object ... args) {
        if (this.state.equals((Object)State.STOPPED)) {
            for (JugglingPin<R> pin : this.sourcePins) {
                try {
                    pin.close(method, args);
                }
                catch (Exception exception) {
                    LoggerManager.getLogger(Juggler.class).error((Throwable)exception);
                }
            }
            this.state = State.DECONSTRUCTED;
        }
    }

    private class ProviderRecoveryWorker
    implements Runnable {
        private final CountDownLatch terminationLatch = new CountDownLatch(1);
        private final CountDownLatch exitLatch = new CountDownLatch(1);
        private final long recoveryCheckMillis;

        public ProviderRecoveryWorker(int recoveryCheckSeconds) {
            this.recoveryCheckMillis = recoveryCheckSeconds * 1000;
        }

        public void abort() throws InterruptedException {
            this.terminationLatch.countDown();
            this.exitLatch.await();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void run() {
            try {
                while (!this.terminationLatch.await(3L, TimeUnit.SECONDS)) {
                    Map.Entry firstEntry;
                    while ((firstEntry = Juggler.this.blacklistMap.firstEntry()) != null && firstEntry.getKey() + this.recoveryCheckMillis <= System.currentTimeMillis()) {
                        if (!firstEntry.getValue().getJugglingPin().recover()) continue;
                        Juggler juggler = Juggler.this;
                        synchronized (juggler) {
                            JugglingPin recoveredPin = Juggler.this.blacklistMap.remove(firstEntry.getKey()).getJugglingPin();
                            if (recoveredPin != null) {
                                Juggler.this.targetPins.add(recoveredPin);
                                LoggerManager.getLogger(Juggler.class).info("Recovered resource(%s) from black list", new Object[]{recoveredPin.describe()});
                            } else {
                                LoggerManager.getLogger(ProviderRecoveryWorker.class).fatal("We've lost a resource(%s), which should never occur - please notify a system administrator", new Object[]{Juggler.this.providerClass.getSimpleName()});
                            }
                        }
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                LoggerManager.getLogger(ProviderRecoveryWorker.class).error((Throwable)interruptedException);
            }
            this.exitLatch.countDown();
        }
    }

    private static enum State {
        DECONSTRUCTED,
        INITIALIZED,
        STARTED,
        STOPPED;

    }
}

