/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.backingStore.ldap;

import javax.naming.InvalidNameException;
import javax.naming.Name;
import org.smallmind.quorum.namespace.JavaName;
import org.smallmind.quorum.namespace.backingStore.ContextCreator;
import org.smallmind.quorum.namespace.backingStore.NameTranslator;
import org.smallmind.quorum.namespace.backingStore.ldap.LdapContextCreator;

public class LdapNameTranslator
extends NameTranslator {
    private static final String LDAP_NODE_PREFIX = "cn=";

    public LdapNameTranslator(ContextCreator contextCreator) {
        super(contextCreator);
    }

    @Override
    public JavaName fromInternalNameToExternalName(Name internalName) throws InvalidNameException {
        JavaName translatedName = new JavaName(this);
        for (int count = 0; count < internalName.size(); ++count) {
            translatedName.add(LDAP_NODE_PREFIX + internalName.get(count));
        }
        return translatedName;
    }

    @Override
    public String fromExternalNameToExternalString(JavaName externalName) {
        StringBuilder externalBuilder = new StringBuilder();
        for (int count = 0; count < externalName.size(); ++count) {
            if (count > 0) {
                externalBuilder.insert(0, ',');
            }
            externalBuilder.insert(0, externalName.get(count));
        }
        return externalBuilder.toString();
    }

    @Override
    public String fromAbsoluteExternalStringToInternalString(String externalName) throws InvalidNameException {
        return this.getInternalString(externalName, true);
    }

    @Override
    public String fromExternalStringToInternalString(String externalName) throws InvalidNameException {
        return this.getInternalString(externalName, false);
    }

    private String getInternalString(String externalName, boolean absolute) throws InvalidNameException {
        String[] parsedArray;
        int insertPos = 0;
        String rootName = ((LdapContextCreator)this.getContextCreator()).getRoot();
        StringBuilder internalBuilder = new StringBuilder();
        if (absolute && externalName.equals(rootName)) {
            throw new InvalidNameException("Parameter (" + externalName + ") must designate a context below the Ldap root context (" + rootName + ")");
        }
        if (absolute && externalName.endsWith(rootName)) {
            internalBuilder.append("java:");
            insertPos = 5;
            parsedArray = externalName.substring(0, externalName.length() - (rootName.length() + 1)).split(",", -1);
        } else {
            parsedArray = externalName.split(",", -1);
        }
        for (int count = 0; count < parsedArray.length; ++count) {
            String parsedName = parsedArray[count];
            int equalsPos = parsedName.indexOf(61);
            if (equalsPos >= 0) {
                if (count > 0) {
                    internalBuilder.insert(insertPos, '/');
                }
            } else {
                throw new InvalidNameException("Parameter (" + externalName + ") is not a proper distinguished Ldap name");
            }
            internalBuilder.insert(insertPos, parsedName.substring(equalsPos + 1).trim());
        }
        return internalBuilder.toString();
    }
}

