/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.smallmind.quorum.pool.PoolConfig;

public class ComplexPoolConfig
extends PoolConfig<ComplexPoolConfig> {
    private final AtomicBoolean reportLeaseTimeNanos = new AtomicBoolean(false);
    private final AtomicBoolean testOnCreate = new AtomicBoolean(false);
    private final AtomicBoolean testOnAcquire = new AtomicBoolean(false);
    private final AtomicBoolean existentiallyAware = new AtomicBoolean(false);
    private final AtomicLong creationTimeoutMillis = new AtomicLong(0L);
    private final AtomicInteger initialPoolSize = new AtomicInteger(0);
    private final AtomicInteger minPoolSize = new AtomicInteger(0);
    private final AtomicInteger maxLeaseTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger maxIdleTimeSeconds = new AtomicInteger(0);
    private final AtomicInteger maxProcessingTimeSeconds = new AtomicInteger(0);

    public ComplexPoolConfig() {
    }

    public ComplexPoolConfig(PoolConfig<?> poolConfig) {
        super(poolConfig);
        if (poolConfig.getConfigurationClass().isAssignableFrom(ComplexPoolConfig.class)) {
            this.setReportLeaseTimeNanos(((ComplexPoolConfig)poolConfig).isReportLeaseTimeNanos());
            this.setTestOnCreate(((ComplexPoolConfig)poolConfig).isTestOnCreate());
            this.setTestOnAcquire(((ComplexPoolConfig)poolConfig).isTestOnAcquire());
            this.setExistentiallyAware(((ComplexPoolConfig)poolConfig).isExistentiallyAware());
            this.setCreationTimeoutMillis(((ComplexPoolConfig)poolConfig).getCreationTimeoutMillis());
            this.setInitialPoolSize(((ComplexPoolConfig)poolConfig).getInitialPoolSize());
            this.setMinPoolSize(((ComplexPoolConfig)poolConfig).getMinPoolSize());
            this.setMaxLeaseTimeSeconds(((ComplexPoolConfig)poolConfig).getMaxLeaseTimeSeconds());
            this.setMaxIdleTimeSeconds(((ComplexPoolConfig)poolConfig).getMaxIdleTimeSeconds());
            this.setMaxProcessingTimeSeconds(((ComplexPoolConfig)poolConfig).getMaxProcessingTimeSeconds());
        }
    }

    @Override
    public Class<ComplexPoolConfig> getConfigurationClass() {
        return ComplexPoolConfig.class;
    }

    public boolean requiresDeconstruction() {
        return this.getMaxLeaseTimeSeconds() > 0 || this.getMaxIdleTimeSeconds() > 0 || this.getMaxProcessingTimeSeconds() > 0;
    }

    public boolean isReportLeaseTimeNanos() {
        return this.reportLeaseTimeNanos.get();
    }

    public ComplexPoolConfig setReportLeaseTimeNanos(boolean reportLeaseTimeNanos) {
        this.reportLeaseTimeNanos.set(reportLeaseTimeNanos);
        return this.getConfigurationClass().cast(this);
    }

    public boolean isExistentiallyAware() {
        return this.existentiallyAware.get();
    }

    public ComplexPoolConfig setExistentiallyAware(boolean existentiallyAware) {
        this.existentiallyAware.set(existentiallyAware);
        return this.getConfigurationClass().cast(this);
    }

    public boolean isTestOnCreate() {
        return this.testOnCreate.get();
    }

    public ComplexPoolConfig setTestOnCreate(boolean testOnCreate) {
        this.testOnCreate.set(testOnCreate);
        return this.getConfigurationClass().cast(this);
    }

    public boolean isTestOnAcquire() {
        return this.testOnAcquire.get();
    }

    public ComplexPoolConfig setTestOnAcquire(boolean testOnAcquire) {
        this.testOnAcquire.set(testOnAcquire);
        return this.getConfigurationClass().cast(this);
    }

    public int getInitialPoolSize() {
        return this.initialPoolSize.get();
    }

    public ComplexPoolConfig setInitialPoolSize(int initialPoolSize) {
        if (initialPoolSize < 0) {
            throw new IllegalArgumentException("Initial pool size must be >= 0");
        }
        this.initialPoolSize.set(initialPoolSize);
        return this.getConfigurationClass().cast(this);
    }

    public int getMinPoolSize() {
        return this.minPoolSize.get();
    }

    public ComplexPoolConfig setMinPoolSize(int minPoolSize) {
        if (minPoolSize < 0) {
            throw new IllegalArgumentException("Minimum pool size must be >= 0");
        }
        this.minPoolSize.set(minPoolSize);
        return this.getConfigurationClass().cast(this);
    }

    public long getCreationTimeoutMillis() {
        return this.creationTimeoutMillis.get();
    }

    public ComplexPoolConfig setCreationTimeoutMillis(long creationTimeoutMillis) {
        if (creationTimeoutMillis < 0L) {
            throw new IllegalArgumentException("Creation timeout must be >= 0");
        }
        this.creationTimeoutMillis.set(creationTimeoutMillis);
        return this.getConfigurationClass().cast(this);
    }

    public int getMaxLeaseTimeSeconds() {
        return this.maxLeaseTimeSeconds.get();
    }

    public ComplexPoolConfig setMaxLeaseTimeSeconds(int maxLeaseTimeSeconds) {
        if (maxLeaseTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum lease time must be >= 0");
        }
        this.maxLeaseTimeSeconds.set(maxLeaseTimeSeconds);
        return this.getConfigurationClass().cast(this);
    }

    public int getMaxIdleTimeSeconds() {
        return this.maxIdleTimeSeconds.get();
    }

    public ComplexPoolConfig setMaxIdleTimeSeconds(int maxIdleTimeSeconds) {
        if (maxIdleTimeSeconds < 0) {
            throw new IllegalArgumentException("Maximum idle time must be >= 0");
        }
        this.maxIdleTimeSeconds.set(maxIdleTimeSeconds);
        return this.getConfigurationClass().cast(this);
    }

    public int getMaxProcessingTimeSeconds() {
        return this.maxProcessingTimeSeconds.get();
    }

    public ComplexPoolConfig setMaxProcessingTimeSeconds(int maxProcessingTimeSeconds) {
        if (maxProcessingTimeSeconds < 0) {
            throw new IllegalArgumentException("Un-returned element timeout must be >= 0");
        }
        this.maxProcessingTimeSeconds.set(maxProcessingTimeSeconds);
        return this.getConfigurationClass().cast(this);
    }
}

