/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.complex;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.smallmind.quorum.pool.complex.ComponentInstance;
import org.smallmind.quorum.pool.complex.ComponentPool;
import org.smallmind.scribe.pen.LoggerManager;

public class ComponentCreationWorker<C>
implements Runnable {
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final ComponentPool<C> componentPool;
    private final AtomicReference<State> stateRef = new AtomicReference();
    private ComponentInstance<C> componentInstance;
    private Exception exception;

    public ComponentCreationWorker(ComponentPool<C> componentPool) {
        this.componentPool = componentPool;
    }

    public ComponentInstance<C> getComponentInstance() {
        return this.componentInstance;
    }

    public boolean abort() throws Exception {
        if (!this.stateRef.compareAndSet(null, State.ABORTED)) {
            this.terminationLatch.await();
            if (State.TERMINATED.equals((Object)this.stateRef.get())) {
                throw this.exception;
            }
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            long startMilliseconds = System.currentTimeMillis();
            this.componentInstance = this.componentPool.getComponentInstanceFactory().createInstance(this.componentPool);
            if (!this.stateRef.compareAndSet(null, State.COMPLETED) && this.componentInstance != null) {
                long totalMilliseconds = System.currentTimeMillis() - startMilliseconds;
                LoggerManager.getLogger(ComponentCreationWorker.class).error("Completed connection(%d ms) is being closed due to a request in the %s state - you may want to increase the connection wait time", new Object[]{totalMilliseconds, this.stateRef.get().name()});
                this.componentInstance.close();
            }
        }
        catch (Exception exception) {
            if (!this.stateRef.compareAndSet(null, State.TERMINATED)) {
                LoggerManager.getLogger(ComponentCreationWorker.class).error((Throwable)exception);
            } else {
                this.exception = exception;
            }
        }
        finally {
            this.terminationLatch.countDown();
        }
    }

    private static enum State {
        COMPLETED,
        ABORTED,
        TERMINATED;

    }
}

