/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.pool.simple;

import java.util.LinkedList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import org.smallmind.quorum.pool.ComponentPoolException;
import org.smallmind.quorum.pool.Pool;
import org.smallmind.quorum.pool.simple.ComponentFactory;
import org.smallmind.quorum.pool.simple.PooledComponent;
import org.smallmind.quorum.pool.simple.SimplePoolConfig;

public class ComponentPool<T extends PooledComponent>
extends Pool {
    private final CountDownLatch exitLatch = new CountDownLatch(1);
    private final CountDownLatch terminationLatch = new CountDownLatch(1);
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final ComponentFactory<T> componentFactory;
    private final LinkedList<T> usedList;
    private final LinkedList<T> freeList;
    private SimplePoolConfig simplePoolConfig = new SimplePoolConfig();

    public ComponentPool(ComponentFactory<T> componentFactory) {
        this.componentFactory = componentFactory;
        this.usedList = new LinkedList();
        this.freeList = new LinkedList();
    }

    public ComponentPool(ComponentFactory<T> componentFactory, SimplePoolConfig simplePoolConfig) {
        this(componentFactory);
        this.simplePoolConfig = simplePoolConfig;
    }

    public synchronized T getComponent() throws ComponentPoolException {
        if (this.closed.get()) {
            throw new ComponentPoolException("Pool has been closed", new Object[0]);
        }
        PooledComponent component = null;
        if (this.freeList.isEmpty()) {
            if (this.simplePoolConfig.getMaxPoolSize() == 0 || this.usedList.size() < this.simplePoolConfig.getMaxPoolSize()) {
                try {
                    component = this.componentFactory.createComponent();
                }
                catch (Exception e) {
                    throw new ComponentPoolException(e);
                }
            } else {
                try {
                    do {
                        this.wait(this.simplePoolConfig.getAcquireWaitTimeMillis());
                        if (this.closed.get()) {
                            throw new ComponentPoolException("Pool has been closed", new Object[0]);
                        }
                        if (!this.freeList.isEmpty()) {
                            component = (PooledComponent)this.freeList.removeFirst();
                            continue;
                        }
                        if (this.simplePoolConfig.getAcquireWaitTimeMillis() <= 0L) continue;
                        throw new ComponentPoolException("ComponentPool(%s) is completely booked", this.componentFactory.getClass().getSimpleName());
                    } while (component == null);
                }
                catch (InterruptedException i) {
                    throw new ComponentPoolException(i);
                }
            }
        } else {
            component = (PooledComponent)this.freeList.removeFirst();
        }
        this.usedList.add(component);
        return (T)component;
    }

    public synchronized void returnComponent(T component) {
        this.usedList.remove(component);
        if (this.usedList.size() + this.freeList.size() < this.simplePoolConfig.getMaxPoolSize()) {
            this.freeList.add(component);
            if (this.simplePoolConfig.getMaxPoolSize() > 0) {
                this.notify();
            }
        } else {
            component.terminate();
        }
        if (this.closed.get() && this.usedList.isEmpty()) {
            this.terminationLatch.countDown();
        }
    }

    public synchronized int poolSize() {
        return this.freeList.size() + this.usedList.size();
    }

    public synchronized int freeSize() {
        return this.freeList.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws InterruptedException {
        if (this.closed.compareAndSet(false, true)) {
            try {
                ComponentPool componentPool = this;
                synchronized (componentPool) {
                    this.notifyAll();
                    if (this.usedList.isEmpty()) {
                        this.terminationLatch.countDown();
                    }
                }
                this.terminationLatch.await();
                for (PooledComponent component : this.freeList) {
                    component.terminate();
                }
            }
            finally {
                this.exitLatch.countDown();
            }
        }
        this.exitLatch.await();
    }
}

