/*
 * Decompiled with CFR 0.152.
 */
package org.smallmind.quorum.namespace.backingStore.ldap;

import java.util.Hashtable;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import org.smallmind.quorum.namespace.backingStore.ContextCreator;
import org.smallmind.quorum.namespace.backingStore.NamingConnectionDetails;

public class LdapContextCreator
extends ContextCreator {
    public LdapContextCreator(NamingConnectionDetails connectionDetails) {
        super(connectionDetails);
    }

    public static void insureContext(DirContext dirContext, String namingPath) throws NamingException {
        String[] pathArray = namingPath.split(",", -1);
        StringBuilder pathSoFar = new StringBuilder();
        for (int count = pathArray.length - 1; count >= 0; --count) {
            if (pathSoFar.length() > 0) {
                pathSoFar.insert(0, ',');
            }
            pathSoFar.insert(0, pathArray[count]);
            try {
                dirContext.lookup(pathSoFar.toString());
                continue;
            }
            catch (NameNotFoundException n) {
                dirContext.createSubcontext(pathSoFar.toString());
            }
        }
    }

    public String getRoot() {
        return this.getConnectionDetails().getRootNamespace();
    }

    @Override
    public DirContext getInitialContext() throws NamingException {
        Hashtable<String, Object> env = new Hashtable<String, Object>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap" + (this.getConnectionDetails().useTLS() ? "s" : "") + "://" + this.getConnectionDetails().getHost() + ":" + this.getConnectionDetails().getPort() + "/" + this.getConnectionDetails().getRootNamespace());
        if (this.getConnectionDetails().useTLS()) {
            env.put("java.naming.security.protocol", "ssl");
        }
        env.put("java.naming.security.authentication", "simple");
        env.put("java.naming.security.principal", this.getConnectionDetails().getUserName());
        env.put("java.naming.security.credentials", this.getConnectionDetails().getPassword());
        return new InitialDirContext(env);
    }
}

